<?php
ini_set('display_errors', 1);

session_start();
header("Access-Control-Allow-Origin: *");
header('Access-Control-Allow-Credentials: true');
header("Access-Control-Allow-Methods: *");
header("Access-Control-Allow-Headers: content-type,X-Custom-Information, authorization");

include "db.php";
include "functions.php";
include ('safemail.php');

$level=$_SESSION['level'];
if (0 === strpos($_SERVER['CONTENT_TYPE'], 'application/json')) {
    $_POST = json_decode(file_get_contents('php://input'), true);
}
$data=null;
if (!empty($_POST)) {
    $command = $_POST['command'];
    if (isset($_POST['command'])) {
        switch ($command) //switch case command
        {
            case 'register':
                if (!empty($_POST['email']) && !empty($_POST['pwd'])&& !empty($_POST['employment'])
                    && !empty($_POST['firstName']) && !empty($_POST['lastName'])
                    && isset($_POST['description']) && !empty($_POST['type'])) {
                    $email=$_POST['email'];
                    $pwd=$_POST['pwd'];
                    $type=$_POST['type'];
                    if($type==2){$employment=0;}
                    else {$employment = getEmployment($_POST['employment'], "employment", $conn);}
                    $description = htmlentities($_POST['description']);
                    $firstName=sanitizeName($_POST['firstName']);
                    $lastName=sanitizeName($_POST['lastName']);
                    $referral=getReferral($email);
                    $subscription=1;
                    $today = date('Y/m/d H:i:s', time());
                    switch ($type){
                        case '1':
                            $db="broker";
                            $info="info_broker";
                            $det=array("brokerFirstName"=>$firstName,"brokerLastName"=>$lastName,"brokerCompany"=>"","brokerEmployment"=>$employment,
                                "brokerEmail"=>$email,
                                "brokerReferral"=>$referral,"brokerSubscription"=>$subscription,"brokerDescription"=>$description,"brokerActivateAccount"=>0);
                            break;
                        case'2':
                            $db="client";
                            $info="info_client";
                            $det=array("clientFirstName"=>$firstName,"clientLastName"=>$lastName,"clientCompany"=>"","clientEmployment"=>$employment,
                                "clientEmail"=>$email,
                                "clientReferral"=>$referral,"clientSubscription"=>$subscription,"clientDescription"=>$description,"brokerActivateAccount"=>0);
                            break;
                    }
                    $details=json_encode($det,true);
                    if(!issetEmail($email,$conn)){
                        $encryptPwd=encryptPassword($pwd,$email);
                        $today = date('Y/m/d H:i:s', time());
                        $tokenEmail=getEmailToken($email,$today);
                        if($stm=$conn->prepare("INSERT INTO $db (`email`,`pwd`,$info,`referral`,`email_validate_token`,`date_creation`)
                                                                    VALUES (?,?,?,?,?,?)")){
                            $stm->bind_param("ssssss",$email,$encryptPwd,$details,$referral,$tokenEmail,$today);
                            if($stm->execute()){
                                $id=$stm->insert_id;
                                if($type==1){
                                    createSeller($conn,$id,$email,$firstName,$lastName,$today,$referral);
                                }
                                //token Email Validation parameters
                                $t=$tokenEmail;
                                $e=$id*$delta;
                                // end token Email validation
                                $subject = 'Registration Request';

                                include ('email/regITA.php');
                                $to = "alessandrosantoro1@gmail.com";
                                $sendMail = safeMail($to, $subject, $message, $alt, "Ikkrea", '');
                                $sendMailConfirmation = safeMail($email, $subjectConfirmation, $messageConfirmation, $altConf, "Ikkrea", '');
                                if ($sendMail == true) {
                                    if ($sendMailConfirmation == true) {
                                        $stm->close();
                                        $conn->close();
                                        $response = appendData($data, '100',TRUE);
                                        echo $json = json_encode($response);
                                    }
                                    else{
                                        $response = appendData($data, '602',TRUE);
                                        echo $json = json_encode($response);
                                    }
                                }
                                else
                                {
                                    sleep(1);
                                    $response = appendData($data, '602',TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                            else {
                                $response = appendData($conn->error, '413', TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                        else {
                            $response = appendData($conn->error, '411', TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '205',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'search':
                if (isset($_POST['id_category_group']) && isset($_POST['id_category_type']) && isset($_POST['search'])) {
                    $group = $_POST['id_category_group'];
                    $type = $_POST['id_category_type'];
                    $district=$_POST['district'];
                    $cap=$_POST['cap'];
                    $search = $_POST['search'];
                    if (empty($search)) {
                        if ($_POST['id_category_group']!=0 &&  $_POST['id_category_type'] == 0) {
                            $string = '"categoryGroup":"' . $group . '"';
                            $query = "SELECT `ID_adv`,`ID_broker`,`ID_seller`,`showPrice`,`showSeller`,`showBroker`,`info_adv`,`advTitle`,`advPrice`,`date_public` FROM `adv` WHERE (`info_adv` LIKE '%$string%') AND `advStatus`=4 ORDER BY `date_public`";
                        } else if(($_POST['id_category_group']!=0 &&  $_POST['id_category_type']!=0)) {
                            $string = '"categoryGroup":"' . $group . '","categoryType":"' . $type . '"';
                            $query = "SELECT `ID_adv`,`ID_broker`,`ID_seller`,`showPrice`,`showSeller`,`showBroker`,`info_adv`,`advTitle`,`advPrice`,`date_public` FROM `adv` WHERE (`info_adv` LIKE '%$string%') AND `advStatus`=4 ORDER BY `date_public`";
                        }
                        else {
                            $query = "SELECT `ID_adv`,`ID_broker`,`ID_seller`,`showPrice`,`showSeller`,`showBroker`,`info_adv`,`advTitle`,`advPrice`,`date_public` FROM `adv` WHERE `advStatus`=4 ORDER BY `date_public`";
                        }
                    } else {
                        if ($_POST['id_category_group']!= 0  && $_POST['id_category_type'] == 0 ){
                            $string = '"categoryGroups":"' . $group . '"';
                            $query = "SELECT `ID_adv`,`ID_broker`,`ID_seller`,`showPrice`,`showSeller`,`showBroker`,`info_adv`,`advTitle`,`advPrice`,`date_public` FROM `adv` WHERE (`info_adv` LIKE '%$string%' AND '%$search%') AND `advStatus`=4 ORDER BY `date_public`";
                        } else if (($_POST['id_category_group']!=0  && $_POST['id_category_type']!=0)) {
                            $string = '"categoryGroup":"' . $group . '","categoryType":"' . $type . '"';
                            $query = "SELECT `ID_adv`,`ID_broker`,`ID_seller`,`showPrice`,`showSeller`,`showBroker`,`info_adv`,`advTitle`,`advPrice`,`date_public` FROM `adv` WHERE (`info_adv` LIKE '%$string%' AND '%$search%') AND `advStatus`=4 ORDER BY `date_public`";
                        } else if ($_POST['id_category_group']==0 && $_POST['id_category_type']==0) {
                            $query = "SELECT `ID_adv`,`ID_broker`,`ID_seller`,`showPrice`,`showSeller`,`showBroker`,`info_adv`,`advTitle`,`advPrice`,`date_public` FROM `adv` WHERE `info_adv` LIKE '%$search%'  AND `advStatus`=4 ORDER BY `date_public`";
                        }
                    }
                    if ($stm = $conn->prepare($query)) {
                        if ($stm->execute()) {
                            $stm->store_result();
                            $stm->bind_result($id,$brokerID,$sellerID,$showPrice,$showSeller,$showBroker,$info,$title,$advPrice,$datePublic);
                            if ($stm->num_rows >=1){
                                while ($stm->fetch()){
                                    $infoAdv=json_decode($info,TRUE);
                                    if($showSeller==0){
                                        $sellerID="hidden";
                                    }
                                    if($showBroker==0){
                                        $brokerID="hidden";
                                    }
                                    if($showPrice==0){
                                        $advPrice="hidden";
                                    }

                                    $photos=getArrayAdvPhoto($id);
                                    if($_POST['district']!=0 && $_POST['district']!='') {
                                            if($infoAdv['district']==$_POST['district']){
                                                if(($_POST['cap'])!=0 && $_POST['cap']!=''){
                                                    if( $infoAdv['cap']===$_POST['cap']){
                                                        $data[]=array("page"=>$id,"title"=>$title,"description"=>$infoAdv['advDescription'],"brokerID"=>$brokerID,"sellerID"=>$sellerID,
                                                            "category_group"=>$infoAdv['categoryGroup'],"category_type"=>$infoAdv['categoryType'],"advPrice"=>$advPrice,
                                                            "district"=>$infoAdv['district'],'cap'=>$infoAdv['cap'],"photo"=> $photos);
                                                    }
                                                }
                                                else {
                                                    $data[] = array("page" => $id, "title" => $title, "description" => $infoAdv['advDescription'], "brokerID" => $brokerID, "sellerID" => $sellerID,
                                                        "category_group" => $infoAdv['categoryGroup'], "category_type" => $infoAdv['categoryType'],"advPrice"=>$advPrice,
                                                        "district" => $infoAdv['district'], 'cap' => $infoAdv['cap'],"photo"=>$photos);
                                                }
                                            }
                                        }
                                    else{
                                        $data[] = array("page" => $id, "title" => $title, "description" => $infoAdv['advDescription'], "brokerID" => $brokerID,
                                            "sellerID" => $sellerID,"advPrice"=>$advPrice,
                                            "category_group" => $infoAdv['categoryGroup'], "category_type" => $infoAdv['categoryType'],
                                            "district" => $infoAdv['district'], 'cap' => $infoAdv['cap'],"photo"=>$photos);
                                    }
                                }
                                if(empty($data)) {
                                    $response = appendData($infoAdv['district'], '210', TRUE);
                                    echo $json = json_encode($response);
                                }
                                elsE {
                                    $response = appendData($data, '100', FALSE);
                                    echo $json = json_encode($response);
                                }
                            }
                            else{
                                $response = appendData($data, '210', TRUE);
                                echo $json = json_encode($response);
                            }
                        } else {
                            $response = appendData($data, '413', TRUE);
                            echo $json = json_encode($response);
                        }
                    } else {
                        $response = appendData($data, '411', TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'validateEmail':
                if (!empty($_POST['t']) && !empty($_POST['e']) && !empty($_POST['r'])){
                    $t=$_POST['t'];
                    $e=intval($_POST['e']);
                    $r=intval($_POST['r']);
                    sleep(1);
                    switch ($r){
                        case '1':
                            $db="broker";
                            $id="ID_broker";
                            break;
                        case'2':
                            $db="client";
                            $id="ID_client";
                            break;
                    }
                    $idValue=$e/$delta;
                    if($stm=$conn->prepare("SELECT $id,email_validated,email_validate_token FROM $db WHERE $id=? LIMIT 1")){
                        $stm->bind_param('i',$idValue);
                        if($stm->execute()) {
                            $stm->store_result();
                            $stm->bind_result($idUser,$emailValidated,$token);
                            $stm->fetch();
                            if ($stm->num_rows == 1) {
                                if($emailValidated==0){
                                    if($t==$token) {
                                        $verify = updateTokenEmail($t, $idUser, $r, $conn);
                                        if ($verify === 1) {
                                            $response = appendData($data, '100', FALSE);
                                            echo $json = json_encode($response);
                                        } else {
                                            $response = appendData($verify, '301', TRUE);
                                            echo $json = json_encode($response);
                                        }
                                    }
                                    else{
                                        $response = appendData($data, '207',TRUE);
                                        echo $json = json_encode($response);
                                    }
                                }
                                else{
                                    $response = appendData($data, '302',TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                            else{
                                $response = appendData($data, '210',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                        else{
                            $response = appendData($data, '411',TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '411',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'resendValidateEmail':
                if (!empty($_POST['email'])){
                    $email=$_POST['email'];
                    $checkEmailValidated=checkEmailValidated($email,$conn,$delta);
                    if($checkEmailValidated['error']==false){
                        $t=$checkEmailValidated['result']['t'];
                        $e=$checkEmailValidated['result']['e'];
                        $type=$checkEmailValidated['result']['r'];
                        include ('email/validateEmailITA.php');
                        $subject="Email validation";
                        $sendMailConfirmation = safeMail($email, $subject, $messageConfirmation, $altConf, "Ikkrea", '');
                        if ($sendMailConfirmation == true) {
                            $response = appendData($data, '100',TRUE);
                            echo $json = json_encode($response);
                        }
                        else{
                            $response = appendData($data, '602',TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData("che", $checkEmailValidated['code'],TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'getUsername':
                if(!empty($_POST['t']) && !empty($_POST['e']) && !empty($_POST['r'])){
                    $token=$_POST['t'];
                    $e=$_POST['e'];
                    $r=$_POST['r'];
                    $id = $e / $delta;
                    switch ($r){
                        case'1':
                            $query="SELECT `email`,`pwd_token` from `broker` WHERE  `ID_broker`=? ";
                            break;
                        case '2':
                            $query="SELECT `email`,`pwd_token` from `client` WHERE  `ID_client`=? ";
                            break;
                        default:
                            $db="error";
                    }
                    if($db=="error"){
                        $response = appendData($data, '402', TRUE);
                        echo json_encode($response);
                    }
                    else{
                        if ($stm1 = $conn->prepare($query)) {
                            $stm1->bind_param("i", $id);

                            if ($stm1->execute()) {
                                $stm1->store_result();
                                $stm1->bind_result($email,$validateToken);
                                $stm1->fetch();
                                if ($stm1->num_rows == 1) {
                                    if($validateToken!==null) {
                                        if($validateToken==$token) {
                                            $response = appendData($email, '100', FALSE);
                                            echo $json = json_encode($response);
                                            $stm1->close();
                                            $conn->close();
                                        }
                                        else{
                                            $response = appendData($data, '207', TRUE);
                                            echo $json = json_encode($response);
                                            $stm1->close();
                                            $conn->close();
                                        }
                                    }
                                    else{
                                        $response = appendData($data, '206', TRUE);
                                        echo $json = json_encode($response);
                                        $stm1->close();
                                        $conn->close();
                                    }
                                }
                                else {
                                    $response = appendData("getU", '210', TRUE);
                                    $stm1->close();
                                    $conn->close();
                                    echo $json = json_encode($response);
                                }
                            }
                            else {
                                $response = appendData($data, '413', TRUE);
                                $stm1->close();
                                $conn->close();
                                echo $json = json_encode($response);
                            }
                        }
                        else {
                            $response = appendData($data, '411', TRUE);
                            $stm1->close();
                            $conn->close();
                            echo $json = json_encode($response);
                        }
                    }
                }
                else {
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'resetPwd':
                if(!empty($_POST['email'])){
                    $username = $_POST['email'];
                    $checkEmail=checkEmail($username,$conn);
                    if($checkEmail['error']===false) {
                        switch ($checkEmail['result']['r']) {
                            case'1':
                                $queryUpdate = "UPDATE `broker` SET `pwd`=?,`pwd_token`=?  WHERE `email`=? limit 1 ";
                                break;
                            case'2':
                                $queryUpdate = "UPDATE `client` SET `pwd`=?,`pwd_token`=?  WHERE `email`=? limit 1 ";
                                break;
                            default:
                                $db = "error";
                        }
                        if ($db == "error") {
                            $response = appendData($data, '402', TRUE);
                            echo json_encode($response);
                        } else {
                            $type=$checkEmail['result']['r'];
                            $idEmail=$checkEmail['result']['id'];
                            $today = date('Y-m-d H:i:s', time());
                            $tempPwd = hash('sha256', $today);
                            $token = getEmailToken($username, $today);
                            $e = $delta * $idEmail;
                            $r = $type;
                            if ($stm = $conn->prepare($queryUpdate)) {
                                $stm->bind_param("sss", $tempPwd, $token, $username);
                                if ($stm->execute()) {
                                    include "email/resetPwd.php";
                                    $subject = "Recovery Password";
                                    $to = $username;
                                    $sendMailRecovery = safeMail($to, $subject, $message, $altMessage, 'Ikkrea', '');
                                    if ($sendMailRecovery) {
                                        $conn->close();
                                        $stm->close();
                                        $response = appendData($data, '100', FALSE);
                                        echo json_encode($response);
                                    } else {
                                        $conn->close();
                                        $stm->close();
                                        $response = appendData($data, '602', TRUE);
                                        echo json_encode($response);
                                    }
                                } else {
                                    $response = appendData($data, '410', TRUE);
                                    echo $json = json_encode($response);
                                }
                            } else {
                                $response = appendData($conn->error, '411', TRUE);
                                echo $json = json_encode($response);
                            }
                        }

                    }
                    else {
                        $response = appendData($data, $checkEmail['code'], TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'setNewPwd':
                if(!empty($_POST['t']) && !empty($_POST['e']) && !empty($_POST['r']) && !empty($_POST['newP'])){
                    $token=$_POST['t'];
                    $e=$_POST['e'];
                    $r=$_POST['r'];
                    $id = $e / $delta;
                    $newPwd = $_POST['newP'];
                    $today = date('Y/m/d H:i:s', time());

                    switch ($r){
                        case'1':
                            $query="SELECT `email` from `broker` WHERE  `ID_broker`=?";
                            $queryUpdate="UPDATE `broker` SET `pwd`=?,`pwd_token`=NULL,`date_pwd_change`=? WHERE  `ID_broker`=? AND `email`=?";
                            break;
                        case '2':
                            $query="SELECT `email` from `client` WHERE  `ID_client`=?";
                            $queryUpdate="UPDATE `client` SET `pwd`=?,`pwd_token`=NULL,`date_pwd_change`=? WHERE  `ID_client`=? AND `email`=?";
                            break;
                        default:
                            $db="error";
                    }
                    if($db=="error"){
                        $response = appendData($data, '402', TRUE);
                        echo json_encode($response);
                    }
                    else {
                        if (!preg_match('/^(?=.*\d)(?=.*[A-Za-z])[0-9A-Za-z_!.&@#$%]{8,20}$/', $newPwd)) {
                            $response = appendData($data, '416', TRUE);
                            echo $json = json_encode($response);
                        }
                        else {
                            if ($stm1 = $conn->prepare($query)) {
                                $stm1->bind_param("i", $id);

                                if ($stm1->execute()) {
                                    $stm1->store_result();
                                    $stm1->bind_result($email);
                                    $stm1->fetch();
                                    if ($stm1->num_rows == 1) {
                                        $cryptoPwd = encryptPassword($newPwd, $email);
                                        if($stmUpdateNewPwd=$conn->prepare($queryUpdate)){
                                            $stmUpdateNewPwd->bind_param("ssis",$cryptoPwd,$today,$id,$email);
                                            if($stmUpdateNewPwd->execute()){
                                                $stm1->close();

                                                $response = appendData($data, '100', FALSE);
                                                echo $json = json_encode($response);
                                                $stmUpdateNewPwd->close();
                                                $conn->close();
                                            }
                                            else{
                                                $response = appendData($data, '413', TRUE);
                                                $stmUpdateNewPwd->close();
                                                $stm1->close();
                                                $conn->close();
                                                echo $json = json_encode($response);
                                            }
                                        }
                                        else {
                                            $response = appendData($data, '411', TRUE);
                                            $stmUpdateNewPwd->close();
                                            $stm1->close();
                                            $conn->close();
                                            echo $json = json_encode($response);
                                        }

                                    } else {
                                        $response = appendData("em", '210', TRUE);
                                        $stm1->close();
                                        $conn->close();
                                        echo $json = json_encode($response);
                                    }
                                } else {
                                    $response = appendData($data, '413', TRUE);
                                    $stm1->close();
                                    $conn->close();
                                    echo $json = json_encode($response);
                                }
                            } else {
                                $response = appendData($data, '411', TRUE);
                                $stm1->close();
                                $conn->close();
                                echo $json = json_encode($response);
                            }
                        }

                    }
                }
                else {
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'login':
                if(!empty($_POST['email']) && !empty($_POST['pwd'])){
                    $type=intval($_POST['type']);
                    $email=$_POST['email'];
                    $pwd=$_POST['pwd'];
                    $encryptPwd=encryptPassword($pwd,$email);
                    $today = date('Y/m/d H:i:s', time());
                    $infoLogin=issetEmailLogin($email,$conn);
                    if($infoLogin['error']===false){
                        $pwdUser=$infoLogin['pwdUser'];
                        $t_login=createToken($infoLogin['idUser'],$email,$today);
                        if($pwdUser===$encryptPwd){
                            if($infoLogin['type']==1){

                                $data=array("type"=>1,"token"=>$t_login);
                                $updateLogin=updateLogin($conn,$t_login,$infoLogin['idUser'],$email,1);
                                $response = appendData($data, 100,FALSE);
                                echo $json = json_encode($response);
                            }
                            else if ($infoLogin['type']==2){
                                $updateLogin=updateLogin($conn,$t_login,$infoLogin['idUser'],$email,2);
                                if($updateLogin['error']===false){
                                    $data=array("type"=>2,"token"=>$t_login,"firstName"=>$infoLogin['firstName'],"lastName"=>$infoLogin['lastName']);
                                    $response = appendData($data, 100,FALSE);
                                    echo $json = json_encode($response);
                                }
                                else{
                                    $response = appendData($updateLogin['errorNo'], $updateLogin['code'],TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                            else{
                                $response = appendData("type", '410',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                        else{
                            $response = appendData($data, 503,TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData("2", $infoLogin['code'],TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'logout':
                if(!empty($_POST['t_login'])){

                    $token=$_POST['t_login'];
                    $validToken=isValidToken($token);
                    if ($validToken === true) {
                        $issetToken = issetToken($conn, $token);
                        if ($issetToken['error'] === FALSE) {
                            if (emptyToken($conn, $token,$issetToken['type'])) {
                                sleep(1);
                                $response = appendData($data, '100', FALSE);
                                echo json_encode($response);
                            } else {
                                sleep(1);
                                $response = appendData($data, '206', TRUE);
                                echo $json = json_encode($response);
                            }
                        } else {
                            $response = appendData($data, $issetToken['code'], TRUE);
                            echo json_encode($response);
                        }
                    }
                    else {
                        $response = appendData($data, '207', TRUE);
                        echo json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'getAdv':
                if(!empty($_POST['id'])){
                    $id=intval($_POST['id']);
                    /*$query="SELECT `ID_adv`,`ID_broker`, `ID_seller`, `self_seller`,
                                    `info_adv`,`advPrice`,`advTitle`,`showPrice`,`showSeller`,`showBroker`
                                    FROM `adv` 
                            WHERE `ID_adv`=? 
                              AND `deleted`=0 AND `completed`=0 AND `published`=1";*/
                    $query="SELECT `ID_adv`,`ID_broker`, `ID_seller`, `self_seller`,
                                    `info_adv`,`advPrice`,`advTitle`,`showPrice`,`showSeller`,`showBroker`
                                    FROM `adv` 
                            WHERE `ID_adv`=? 
                              AND `deleted`=0 AND `advStatus`=4";

                    if($stm=$conn->prepare($query)){
                        $stm->bind_param("i",$id);
                        if($stm->execute()){
                            $stm->store_result();
                            $stm->bind_result($idAdv,$idBroker,$idSeller,$selfSeller,
                                                $advInfoDecoded,$advPrice,$advTitle,$showPrice,$showSeller,$showBroker);
                            $stm->fetch();
                            $advInfo=json_decode($advInfoDecoded,true);
                            $advDescription=$advInfo['advDescription'];
                            $categoryGroup=$advInfo['categoryGroup'];
                            $categoryType=$advInfo['categoryType'];
                            $cap=$advInfo['cap'];
                            $district=$advInfo['district'];
                            if($showPrice==0){
                                $advPrice="hidden";
                            }
                            if($showBroker==0){
                                $brokerInfo=array("ShowBroker"=>0);
                            }
                            else{
                                if($idBroker==0){
                                    $brokerInfo=array(
                                        "ShowBroker"=>1,
                                        "ID"=>0,
                                        "Name"=>"Ikkrea",
                                        "Email"=>"info@ikkrea.it");
                                }
                                else {
                                    $brokerData = getBrokerInfo($idBroker, $conn);
                                    $brokerData = json_decode($brokerData, true);
                                    $brokerName=$brokerData['brokerFirstName']." - ".$brokerData['brokerLastName'];
                                    $brokerInfo = array(
                                        "ShowBroker" => 1,
                                        "ID"=>$idBroker,
                                        "Email" => $brokerData['brokerEmail'],
                                        "Name" => $brokerName,

                                    );
                                }
                            }


                            if($showSeller==0){
                                $sellerInfo=array("ShowSeller"=>0);
                            }
                            else{
                                if($idSeller!=0) {
                                    if($selfSeller==1){
                                        $sellerInfo=$brokerInfo;
                                    }
                                    else {
                                        $sellerData = getSellerInfo($idSeller, $conn);
                                        $sellerData = json_decode($sellerData, true);
                                        $sellerName = $sellerData['sellerFirstName'] . " - " . $sellerData['sellerLastName'];
                                        $sellerInfo = array(
                                            "ShowSeller" => 1,
                                            "ID"=>$idSeller,
                                            "Email" => $sellerData['sellerEmail'],
                                            "Name" => ($sellerName)
                                        );
                                    }
                                }
                                else{
                                    $sellerInfo=array(
                                            "ShowSeller"=>1,
                                            "ID"=>0,
                                            "Name"=>"Ikkrea",
                                            "Email"=>"info@ikkrea.it");
                                }
                            }
                            $photo=getArrayAdvPhoto($id);

                            if($stm->num_rows==1){
                                $data=array("advID"=>$id,
                                            "advTitle"=>$advTitle,"advDescription"=>$advDescription, "advPrice"=>$advPrice,
                                            "categoryGroup"=>$categoryGroup,"categoryType"=>$categoryType,
                                            "cap"=>$cap,"district"=>$district,
                                            "photo"=>$photo,
                                            "sellerInfo"=>$sellerInfo,
                                            "brokerInfo"=>$brokerInfo);
                                $response = appendData($data,'100',FALSE);
                                echo $json = json_encode($response);
                            }
                            else{
                                $response = appendData($data,'210',TRUE);
                                echo $json = json_encode($response);
                            }

                        }
                        else{
                            $response = appendData($data, '413',TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '411',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'addBookmark':
                if(!empty($_POST['t_login']) && !empty($_POST['i']) && !empty($_POST['g']) && !empty($_POST['t'])){
                    $token = trim($_POST['t_login']);
                    $validToken=isValidToken($token);
                    if ($validToken === true) {
                        $issetToken = issetToken($conn, $token);
                        if ($issetToken['error'] === false) {
                            $idClient=$issetToken['ID_client'];
                            $bookmarkID=intval($_POST['i']);
                            $bookmarkGroup=intval($_POST['g']);
                            $bookmarkType=$_POST['t'];
                            $newBookmarkAdded=array("i"=>$bookmarkID,"g"=>$bookmarkGroup,"t"=>$bookmarkType);

                            $querySearchBookmarks="SELECT `bookmarks` FROM `client` WHERE `t_login`=? LIMIT 1";
                            if($stm=$conn->prepare($querySearchBookmarks)){
                                $stm->bind_param('s',$token);
                                if($stm->execute()) {
                                    $stm->store_result();
                                    $stm->bind_result($oldBookmarks);
                                    $stm->fetch();
                                    $alreadyAdded=0;
                                    if($oldBookmarks!==null){
                                        $old=json_decode($oldBookmarks,true);
                                        foreach ($old as $key => $val) {
                                            if ($val['i'] === $bookmarkID) {
                                                $alreadyAdded=1;
                                            }
                                        }
                                        $old[]=$newBookmarkAdded;
                                        foreach ($old as $singleArray){
                                            $newBookmarkArray[]=$singleArray;
                                        }

                                    }
                                    else{
                                        $newBookmarkArray[]=$newBookmarkAdded;
                                    }
                                    if($alreadyAdded!==1) {

                                        $newBookmarkArray=json_encode($newBookmarkArray,true);
                                        $queryUpdateNewBookmarks = "UPDATE `client` SET `bookmarks`=? where `t_login`=?";
                                        if ($stm1 = $conn->prepare($queryUpdateNewBookmarks)) {
                                            $stm1->bind_param("ss", $newBookmarkArray, $token);
                                            if ($stm1->execute()) {
                                                $response = appendData($newBookmarkArray, '100', FALSE);
                                                echo json_encode($response);
                                            } else {
                                                sleep(1);
                                                $stm->close();
                                                $stm1->close();
                                                $conn->close();
                                                $response = appendData($data, '413', TRUE);
                                                echo json_encode($response);
                                            }
                                        } else {
                                            sleep(1);
                                            $response = appendData($data, '411', TRUE);
                                            echo json_encode($response);
                                        }
                                    }
                                    else {
                                        sleep(1);
                                        $response = appendData($data, '209', TRUE);
                                        echo json_encode($response);
                                    }
                                }
                                else {
                                    sleep(1);
                                    $response = appendData($data, '413', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else {
                                sleep(1);
                                $response = appendData($data, '411', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else {
                            sleep(1);
                            $response = appendData($data, '206', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else {
                        sleep(1);
                        $response = appendData($data, '207', TRUE);
                        echo json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'getBookmarks':
                if(!empty($_POST['t_login'])) {
                    $token = trim($_POST['t_login']);
                    $validToken = isValidToken($token);
                    if ($validToken === true) {
                        $issetToken = issetToken($conn, $token);
                        if ($issetToken['error'] === false) {
                            if($stm=$conn->prepare("SELECT `bookmarks` FROM `client` WHERE `t_login`=? LIMIT 1")){
                                $stm->bind_param("s",$token);

                                if($stm->execute()) {
                                    $stm->store_result();
                                    $stm->bind_result($bookmarksClient);
                                    $stm->fetch();
                                    if($bookmarksClient!==null){
                                        $response = appendData($bookmarksClient, '100', FALSE);
                                        echo json_encode($response);
                                    }
                                    else{
                                        sleep(1);
                                        $response = appendData($data, '210', TRUE);
                                        echo json_encode($response);
                                    }
                                }
                            }
                            ELSE{
                                sleep(1);
                                $response = appendData($data, '411', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else {
                            sleep(1);
                            $response = appendData($data, '206', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else {
                        sleep(1);
                        $response = appendData($data, '207', TRUE);
                        echo json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'delBookmark':
                if(!empty($_POST['t_login']) && !empty($_POST['i'])){
                    $token = trim($_POST['t_login']);
                    $validToken=isValidToken($token);
                    if ($validToken === true) {
                        $issetToken = issetToken($conn, $token);
                        if ($issetToken['error'] === false) {
                            $bookmarkID=intval($_POST['i']);
                            $querySearchBookmarks="SELECT `bookmarks` FROM `client` WHERE `t_login`=? LIMIT 1";
                            if($stm=$conn->prepare($querySearchBookmarks)){
                                $stm->bind_param('s',$token);
                                if($stm->execute()) {
                                    $stm->store_result();
                                    $stm->bind_result($oldBookmarks);
                                    $stm->fetch();

                                    if($oldBookmarks!==null){
                                        $old=json_decode($oldBookmarks,true);
                                        foreach ($old as $key => $val) {
                                            if ($val['i'] === $bookmarkID) {
                                                $alreadyAdded=1;
                                            }
                                        }
                                        if($alreadyAdded===1)
                                        {
                                            foreach ($old as $i => $v) {
                                                if ($v['i'] == $bookmarkID) {
                                                    unset($old[$i]);
                                                }
                                            }
                                            foreach ($old as $singleArray){
                                                $newBookmarkArray[]=$singleArray;
                                            }
                                            $newBookmarkArray=json_encode($newBookmarkArray,true);
                                            $queryUpdateNewBookmarks = "UPDATE `client` SET `bookmarks`=? where `t_login`=?";
                                            if ($stm1 = $conn->prepare($queryUpdateNewBookmarks)) {
                                                $stm1->bind_param("ss", $newBookmarkArray, $token);
                                                if ($stm1->execute()) {
                                                    $response = appendData($newBookmarkArray, '100', FALSE);
                                                    echo json_encode($response);
                                                } else {
                                                    sleep(1);
                                                    $stm->close();
                                                    $stm1->close();
                                                    $conn->close();
                                                    $response = appendData($data, '413', TRUE);
                                                    echo json_encode($response);
                                                }
                                            } else {
                                                sleep(1);
                                                $response = appendData($data, '411', TRUE);
                                                echo json_encode($response);
                                            }
                                        }
                                        else {
                                            sleep(1);
                                            $response = appendData($data, '208', TRUE);
                                            echo json_encode($response);
                                        }
                                    }

                                }
                                else {
                                    sleep(1);
                                    $response = appendData($data, '413', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else {
                                sleep(1);
                                $response = appendData($data, '411', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else {
                            sleep(1);
                            $response = appendData($data, '206', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else {
                        sleep(1);
                        $response = appendData($data, '207', TRUE);
                        echo json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            case 'contactUs':
                if(!empty($_POST['text']) && !empty($_POST['ID'])){
                    $ID_adv=intval($_POST['ID']);
                    $now = date('Y-m-d H:i:s', time());
                    $text = htmlentities($_POST['text']);
                    $checkID_Adv=checkID_Adv($ID_adv,$conn);
                    if ($checkID_Adv['error'] === false) {

                        if (isset($_POST['t_login'])) {
                            $token = trim($_POST['t_login']);
                            $validToken = isValidToken($token);
                            if ($validToken === true) {
                                $issetToken = issetToken($conn, $token);
                                if ($issetToken['error'] === false) {
                                    $registered = 1;
                                    $type = 2;
                                    $email = $issetToken['email'];

                                    $query = "INSERT into `contactus`(`ID_adv`,`text`,`registered`,`email`,`type`,`date_creation`,`ID_broker`)
                                                   VALUES(?,?,?,?,?,?,?)";
                                    if ($stm = $conn->prepare($query)) {
                                        $stm->bind_param("isisis", $ID_adv, $text, $registered, $email, $type, $now, $ID_broker);
                                        if ($stm->execute()) {
                                            $response = appendData("insert", '100', FALSE);
                                            echo json_encode($response);
                                        } else {
                                            sleep(1);
                                            $response = appendData("insert", '413', TRUE);
                                            echo json_encode($response);
                                        }
                                    } else {
                                        sleep(1);
                                        $response = appendData("insert", '411', TRUE);
                                        echo json_encode($response);
                                    }
                                } else {
                                    sleep(1);
                                    $response = appendData($data, '206', TRUE);
                                    echo json_encode($response);
                                }
                            } else {
                                sleep(1);
                                $response = appendData($data, '207', TRUE);
                                echo json_encode($response);
                            }
                        } else {
                            if (isset($_POST['email'])) {
                                $email = $_POST['email'];
                                $checkEmail = issetEmailContactUs($email, $conn);
                                if ($checkEmail['error'] == false) {
                                    if ($checkEmail['code'] == 210) {
                                        $registered = 0;
                                        $type = 0;
                                    } else {
                                        $registered = 1;
                                        $type = $checkEmail['type'];
                                    }

                                    $query = "INSERT into `contactus`(`ID_adv`,`text`,`registered`,`email`,`type`,`date_creation`)
                                                   VALUES(?,?,?,?,?,?)";
                                    if ($stm = $conn->prepare($query)) {
                                        $stm->bind_param("isisis", $ID_adv, $text, $registered, $email, $type, $now);
                                        if ($stm->execute()) {
                                            $response = appendData($checkEmail, '100', FALSE);
                                            echo json_encode($response);
                                        } else {
                                            sleep(1);
                                            $response = appendData("insert", '413', TRUE);
                                            echo json_encode($response);
                                        }
                                    } else {
                                        sleep(1);
                                        $response = appendData("insert", '411', TRUE);
                                        echo json_encode($response);
                                    }
                                } else {
                                    $response = appendData("no tok", $checkEmail['code'], TRUE);
                                    echo json_encode($response);
                                }
                            } else {
                                $response = appendData("email", '410', TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else {
                        $response = appendData($data, $checkID_Adv['code'],TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '410',TRUE);
                    echo $json = json_encode($response);
                }
                break;
            default:
                sleep(1);
                $response = appendData("Wrong Command", '408',TRUE);
                echo json_encode($response);
                break;
        }
    }
    else {
        $response = appendData($data, '409', TRUE);
        echo json_encode($response);
    }
}



function appendData($data,$resultCode='100',$error)
{
    $resultCodeToText = array
    (
        '100' => 'OK',
        '101' => 'No CSRFName found',
        '102' => 'Invalid CSRF token.',
        '103' => 'Too many Retry account blocked for 5 minutes',
        '104' => 'Wrong Password',
        '105' => 'Qr image Error',
        '106' => 'Qr image Ok',
        '107' => 'Insert Code',
        '108' => 'Error Server Connection aborted',
        '109' => 'Cannot Found Database',
        '110' => 'No Results',
        '111' => 'Not logged',
        '112' => 'Unauthorised',
        '113' => 'Already Logged',
        '201' => 'Authentication Error',
        '202' => 'Bad Authentication value',
        '203' => 'Bad Authentication parameter',
        '204' => 'Wrong parameter',
        '205' => 'Email Already Exists',
        '206' => 'Token Expired',
        '207' => 'Wrong Token',
        '208' => 'Bookmark Already deleted',
        '209' => 'Bookmark Already added',
        '210' => 'No Results.',
        '301' => 'Token Expired',
        '302' => 'Email already Validated',
        '401' => 'Bad request',
        '402' => 'Incorrect Parameter Value',
        '403' => 'User Not Allowed',
        '408' => 'Wrong Command',
        '409' => 'Missing Command',
        '410' => 'Required parameter missing',
        '411' => 'Query Error.',
        '412' => 'DB error. Try again later.',
        '413' => 'Execute Query Error',
        '414' => 'Captcha_Error',
        '415' => 'Captcha_Wrong',
        '416' => 'Missed Password Parameters',
        '417' => 'Different Password',
        '501' => 'Fill the form correctly',
        '502' => 'Email not exists',
        '503' => 'Wrong Password',
        '602' => 'Email not Sent',
        '800' => 'Invalid Type Docs',
        '801' => 'Error Uploading File',
        '802' => 'Invalid file Size or Type',
        '803' => 'Image Uploaded Successfully!',
        '804' => 'File already exists',
        '805' => 'File Error',
        '806' => 'Max 3 upload'
    );
    $response['resultCode'] = $resultCode;
    $response['errorText'] = $resultCodeToText[$resultCode];
    $response['error'] = $error;
    $response['result'] = $data;
    return $response;
}

