<!-- Confirm Modal-->
<div class="modal fade" id="product5Modal" tabindex="-1" role="dialog" aria-labelledby="product5Modal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content border-left-danger">
            <div class="modal-header">
                <h5 class="modal-title text-danger"><b data-translate="_confirm">Confirm</b> <span data-translate="_purchase">Purchase</span></h5>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <b aria-hidden="true">×</b>
                </button>
            </div>
            <div class="payments-5-loading text-center text-gray-800"></div>
            <div class="modal-body payments-5 text-gray-800">
                <p data-translate="_sure" >Are you sure?</p>
                <span data-translate="_confirmBuy">You decided to buy</span> 10 <span data-translate="_advs">Advs</span>
                <br><br>
                <div class="text-center h3 mb-0 font-weight-bold ">€400,00</div>
                <p id="result"></p>
            </div>
            <div class="modal-body">
                <div id="paypal-button-container-5"></div>
                <script>
                    paypal.Buttons({
                        style: {
                            shape: 'rect',
                            color: 'silver',
                            layout: 'horizontal',
                            label: 'paypal',
                            tagline: false
                        },
                        createOrder: function(data, actions) {
                            $('.payments-3').hide();
                            $('.payments-3-loading').html("<div class=\"payment-5-spinner spinner-border text-danger mb-5\" style='margin: 50px;' role=\"status\">\n" +
                                "  <span class=\"sr-only\">Loading...</span>\n" +
                                "</div>");

                            return actions.order.create({
                                purchase_units: [{
                                    amount: {
                                        value: '400'
                                    }
                                }]
                            });
                        },
                        onCancel: function (data, actions) {
                            location.reload();
                        },
                        onError: function(error) {
                            location.reload();
                        },
                        onApprove: function(data, actions) {
                            return actions.order.capture().then(function(details) {
                                $.ajax({
                                    type: "POST",
                                    url: "handlers/api.php",
                                    data: {
                                        command: "addPayment",
                                        details:details,
                                        code:5
                                    },
                                    success: function (data) {
                                        $('.payments-5').show();
                                        $('.payment-5-spinner').hide();
                                        $('#product5Modal').modal('hide');
                                        var data_obj = $.parseJSON(data);
                                        var code = data_obj['resultCode'];
                                        var error = data_obj['error'];
                                        var errorText = data_obj['errorText'];
                                        var result = data_obj['result'];
                                        if (error === false) {
                                            window.location.href=result;
                                        }
                                        else {
                                            $('#result').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                                            traduction();
                                        }
                                    }
                                });
                            });
                        }
                    }).render('#paypal-button-container-5');
                </script>
            </div>
        </div>
    </div>
</div>

