$(document).ready(function() {
    $.ajax({
        type: "POST",
        url: "handlers/api.php",
        data: {
            command: "tablePaymentsUser",
        },
        success: function (data) {
            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === false && result != null) {
                    $('#tablePayments').DataTable({
                        data: result,
                        lengthMenu: [[20, 35, 50, -1], [20, 35, 50, "All"]],
                        columns: [
                            {
                                'data': 'ID'
                            },
                            {
                                'data':'adv'
                            },
                            {
                                'data': 'status'
                            },
                            {
                                'data': 'amount'
                            },
                            {
                                'data': 'date'
                            }
                        ]
                    });


                }
                else{
                    $('#tablePayments').DataTable({});
                }
                traduction();

            }
        }
    });
});

