function fasterPreview( uploader ) {
    if ( uploader.files && uploader.files[0] ){
        $('#profileImage').attr('src',
            window.URL.createObjectURL(uploader.files[0]) );
    }
}

$(document).ready(function() {
    var ref = getUrlVars()["c"];
    $('input:file').on("change", function() {
        $('button:submit').show();
    });

    $('.confirmEditBrokerBtn').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> <span data-translate="_loading">Loading</span>...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        var dial = {};
        $(".dialogData").each(function () {
            var i = $(this).val();
            var h = $(this).attr('id');
            if(h === "brokerActivateAccount"){
                if($('input[name="brokerActivateAccount"]').is(':checked')){
                    i=1;
                }
                else{
                    i=0;
                }
            }
            dial[h] = i;
        });

        var info = JSON.stringify(dial);if( result !== info) {

            var csrfToken = $('input[name="CSRFToken"]').val();
            var csrfName = $('input[name="CSRFName"]').val();
            $.ajax({

                type: "POST",
                url: "handlers/api.php",
                data: {
                    command: "editBroker",
                    details: info,
                    CSRFName: csrfName,
                    CSRFToken: csrfToken
                },
                success: function (data) {
                    console.log(data);
                    if (IsJsonString(data) === true) {
                        var data_obj = $.parseJSON(data);
                        var code = data_obj['resultCode'];
                        var error = data_obj['error'];
                        var errorText = data_obj['errorText'];
                        var result = data_obj['result'];
                        if (error === false) {
                            location.reload();
                        }
                        else {
                            $this.html("<span data-translate=\"_confirm\">Confirm</span>>");
                            $('#result').html('<span style="color: #ff0000" data-translate="_error'+code+'">'+errorText+'</span>');
                            traduction();
                        }
                    }
                }
            });
        }
    });
    var form = $("#editBroker");
    $('.deleteImgProfileBtn').click(function () {
        if (form.valid() === true) {
            $('#confirmDeleteBrokerProfileModal').modal('show');
        }
    });
    $('.confirmBrokerBtn').click(function () {
        if (form.valid() === true) {
            $('#confirmEditBrokerModal').modal('show');
        }
    });
    $('.confirmDeleteBrokerProfileBtn').click(function () {
        var csrfToken=$('input[name="CSRFToken"]').val();
        var csrfName=$('input[name="CSRFName"]').val();
        var $this = $(this);
        var referral=$('#brokerReferral').val()

        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "delImgBroker",
                ref: referral,
                CSRFName:csrfName,
                CSRFToken:csrfToken
            },
            success: function (data) {
                console.log(data);
                $this.html(data);
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false ) {
                        window.location.reload();
                    }
                    else {
                        $this.html("<span data-translate=\"_confirm\">Confirm</span>");
                        $('#resultDelete').html('<span style="color: #ff0000" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
            }
        });
    })

    // UPLOAD IMAGE

    $("#profileImage").click(function(e) {
        $("#imageUpload").click();
    });

    $("#imageUpload").change(function(){
        fasterPreview( this );
    });

    $('.uploadImgProfile').show();

    $("#uploadProfileImage").on('submit',(function(e) {
        e.preventDefault();
        var csrfToken=$('input[name="CSRFToken"]').val();
        var csrfName=$('input[name="CSRFName"]').val();
        $("#errorImage").empty();
        var formData=new FormData(this);
        var referral=$('#brokerReferral').val()
        formData.append('ref',referral);
        formData.append('command','uploadProfileImage');
        formData.append('CSRFName',csrfName);
        formData.append('CSRFToken',csrfToken);
        var $this = $('.uploadImgProfileBtn');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }

        $.ajax({
            url: "handlers/api.php",
            type: "POST",
            data: formData,
            contentType: false,
            cache: false,
            processData: false,
            error: function () {
                window.location.reload();
            },
            success: function (data) {
                $this.html("Upload");
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false && result != null) {
                        $('.uploadImgProfileBtn').hide();
                        $('.deleteImgProfileBtn').show();
                        location.reload();
                    }
                    else{
                        $this.removeClass('btn-primary').addClass('btn-warning').html(data);
                    }
                }
            }
        });

    }));


    // CHANGE PWD
    var formPwd = $("#passwordForm");
    $('.changePwd').click(function () {
        traduction();
        if (formPwd.valid() === true) {
            $('#confirmChangePwdModal').modal('show');

        }
    });
    $('.confirmChangePwdBtn').click(function (){
        var pwd=$('#password1').val();
        var pwdC=$('#password2').val();
        var token=$('input[name="CSRFToken"]').val();
        var $this = $(this);
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        var name=$('input[name="CSRFName"]').val();
        console.log(pwd);
        console.log(pwdC);
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "changePwd",
                pwd:pwd,
                pwdC:pwdC,
                CSRFName:name,
                CSRFToken:token
            },
            success: function (data) {
                console.log((data));
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false ) {
                        window.location.reload();
                    }
                    else {
                        $this.html("<span data-translate=\"_confirm\">Confirm</span>");
                        $('#resultDelete').html('<span style="color: #ff0000" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
            }
        });
    });
    $("input[type=password]").keyup(function(){
        var ucase = new RegExp("[A-Z]+");
        var lcase = new RegExp("[a-z]+");
        var num = new RegExp("[0-9]+");

        if($("#password1").val().length >= 8){
            $("#8char").removeClass("fa-times");
            $("#8char").addClass("fa-check");
            $("#8char").css("color","#00A41E");
        }else{
            $("#8char").removeClass("fa-check");
            $("#8char").addClass("fa-times");
            $("#8char").css("color","#FF0004");
        }

        if(ucase.test($("#password1").val())){
            $("#ucase").removeClass("fa-times");
            $("#ucase").addClass("fa-check");
            $("#ucase").css("color","#00A41E");
        }else{
            $("#ucase").removeClass("fa-check");
            $("#ucase").addClass("fa-times");
            $("#ucase").css("color","#FF0004");
        }

        if(lcase.test($("#password1").val())){
            $("#lcase").removeClass("fa-times");
            $("#lcase").addClass("fa-check");
            $("#lcase").css("color","#00A41E");
        }else{
            $("#lcase").removeClass("fa-check");
            $("#lcase").addClass("fa-times");
            $("#lcase").css("color","#FF0004");
        }

        if(num.test($("#password1").val())){
            $("#num").removeClass("fa-times");
            $("#num").addClass("fa-check");
            $("#num").css("color","#00A41E");
        }else{
            $("#num").removeClass("fa-check");
            $("#num").addClass("fa-times");
            $("#num").css("color","#FF0004");
        }

        if($("#password1").val() == $("#password2").val()){
            $("#pwmatch").removeClass("fa-times");
            $("#pwmatch").addClass("fa-check");
            $("#pwmatch").css("color","#00A41E");
        }else{
            $("#pwmatch").removeClass("fa-check");
            $("#pwmatch").addClass("fa-times");
            $("#pwmatch").css("color","#FF0004");
        }
    });


});