$(document).ready(function() {
    Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
    Chart.defaults.global.defaultFontColor = '#858796';

    $.ajax({
        type: "POST",
        url: "handlers/api.php",
        data: {
            command: "getDashboard",
            ref:"index"
        },
        success: function (data) {
            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === false && result != null) {
                    $('.totAdv').html(result.advReport[0].totalAdv);
                    $('.totPub').html(result.advReport[0].pub);
                    $('.totAdvDraft').html(result.advReport[0].draft);
                    $('.totAdvCompleted').html(result.advReport[0].completed);
                    $('.totAdvRejected').html(result.advReport[0].rejected);
                    $('.totAdvPending').html(result.advReport[0].pending);
                    createChartAdv(result.advReport[0]);
                }
            }
        }
    });

    function createChartAdv(advReport) {
        var advReportDiv = document.getElementById("advReport");
        var myPieChart = new Chart(advReportDiv, {
            type: 'doughnut',
            data: {
                labels: ["Pubblicata", "Bozza", "Completata","Rifiutata","In approvazione"],
                datasets: [{
                    data: [advReport.pub,advReport.draft,advReport.completed,advReport.rejected,advReport.pending],
                    backgroundColor: ['#36b9cc','#858796','#1cc88a','#e74a3b','#f6c23e'],
                    hoverBackgroundColor: ['#2c9faf','#858796', '#17a673','#e74a3b','#f6c23e'],
                    hoverBorderColor: "rgba(234, 236, 244, 1)",
                }],
            },
            options: {
                maintainAspectRatio: false,
                tooltips: {
                    backgroundColor: "rgb(255,255,255)",
                    bodyFontColor: "#858796",
                    borderColor: '#dddfeb',
                    borderWidth: 1,
                    xPadding: 15,
                    yPadding: 15,
                    displayColors: false,
                    caretPadding: 10,
                },
                legend: {
                    display: false
                },
                cutoutPercentage: 80,
            },
        });
    }
});