$(document).ready(function() {
    $("#newClient").validate({
        rules: {
            email: {
                required: true,
                email: true,
            },
            firstName: {
                required: true,
                minlength: 2
            },
            lastName: {
                required: true,
                minlength: 2
            }
        },
        highlight: function(element) {
            $(element).addClass("border-left-danger");
            traduction();
        },
        unhighlight: function(element) {
            $(element).removeClass("border-left-danger");
            traduction();
        },

    });

    var form = $("#newClient");
    $('.editClientBtn').click(function () {
        if (form.valid() === true) {
            $('#confirmEditClientModal').modal('show');
        }
    });

    $('.confirmEditClientBtn').click(function () {
        var dial = {};
        var btnId=$(this).attr('id');
        $('#error').val();
        $(".dialogDataClient").each(function () {
            var i = $(this).val();
            var h = $(this).attr('id');
            dial[h] = i;
        });
        var info = JSON.stringify(dial);
        var ref = getUrlVars()["c"];
        var csrfToken = $('input[name="CSRFToken"]').val();
        var csrfName = $('input[name="CSRFName"]').val();
        $.ajax({

            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "editClient",
                details: info,
                CSRFName: csrfName,
                CSRFToken: csrfToken,
                btnId:btnId,
                ref:ref
            },
            success: function (data) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === false) {
                    location.reload();
                }
                else {
                    $('#result').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                    traduction();
                }
            }
        });
    });
});