$(document).ready(function() {
    $.ajax({
        type: "POST",
        url: "handlers/api.php",
        data: {
            command: "tableBroker",
        },
        success: function (data) {
            console.log(data);
            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === false && result != null) {
                    $('#tableBroker').DataTable({
                        data: result,
                        lengthMenu: [[20, 35, 50, -1], [20, 35, 50, "All"]],
                        columns: [
                            {
                                'data': 'firstName'
                            },
                            {
                                'data': 'lastName'
                            },
                            {
                                'data': 'email'
                            },
                            {
                                'data': 'active'
                            },
                            {
                                "data": 'url',
                                "render": function (data) {
                                    return '<div style="text-align:center;width: 100%"><a href="' + data + '" type="button" style="margin: 0;padding: 3px" class="btn btn-xs" id="' + data + '" ><i class="fas fa-edit" style="color: #3c4859"></i></a></div>'
                                }
                            }
                        ]
                    });


                }
                else{
                    $('#tableBroker').DataTable({});
                }
                traduction();

            }
        }
    });
    if($("input.activateAccount").is(':checked')){
        $('#statusBrokerAccount').html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
    }
    else{
        $('#statusBrokerAccount').html('Account <span data-translate="_disabled">Disabled</span>').removeClass('alert-success').addClass('alert-danger');
    }
    $("input[name='activateAccount']").click(function() {
        traduction();
        $('.radio-default label, #statusBrokerAccount').html('Account <span data-translate="_disabled">Disabled</span>').removeClass('alert-success').addClass('alert-danger');
        if(this.checked){
            $(this ).next().html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
            $('#statusBrokerAccount').html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
        }
        else{
            $('#statusBrokerAccount').html('Account <span data-translate="_disabled">Disabled</span>').removeClass('alert-success').addClass('alert-danger');
        }

    });



});

