function fillEditForm(result){
    $.each(result, function(key,value) {
        $('#editBroker').find('select[name="'+key+'"], textarea[name="'+key+'"] , input[name="'+key+'"]').each(function () {
            var $this = $(this);
            switch (this.type) {
                case 'email':
                case 'text':
                case 'textarea':
                    $this.val(value);
                    break;
                case 'checkbox':
                case 'radio':
                    if( value === 1) {
                        this.checked = true;
                        $(this).next().html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
                    }
                    else{
                        this.checked = false;
                        $(this).next().html('Account <span data-translate="_disabled">Disabled</span>').addClass('alert-danger').removeClass('alert-success');
                    }
                    break;
            }
        });
        $('select[name="'+key+'"]').find('option[value="'+value+'"]').attr('selected','selected');
        if (result.activateAccount === 1) {
            traduction();
            $('.radio-default label').html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
            $("input[name='activateAccount']").attr("checked","checked");
            $('#statusBrokerAccount').html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
        }
    });
    traduction();
}
function fasterPreview( uploader ) {
    if ( uploader.files && uploader.files[0] ){
        $('#profileImage').attr('src',
            window.URL.createObjectURL(uploader.files[0]) );
    }
}
function createChartAdv(advReport) {
    var advReportDiv = document.getElementById("advReport");
    var pub=parseInt(advReport.pub,10);
    var draft=parseInt(advReport.draft,10);
    var pending=parseInt(advReport.pending,10);
    var rejected=parseInt(advReport.rejected,10);
    var completed=parseInt(advReport.completed,10);
    var myPieChart = new Chart(advReportDiv, {
        type: 'doughnut',
        data: {
            labels: ["Pubblicata", "Bozza", "Completata","Rifiutata","In approvazione"],
            datasets: [{
                data: [ pub, draft, completed,rejected,pending],
                backgroundColor: ['#36b9cc','#858796','#1cc88a','#e74a3b','#f6c23e'],
                hoverBackgroundColor: ['#2c9faf','#858796', '#17a673','#e74a3b','#f6c23e'],
                hoverBorderColor: "rgba(234, 236, 244, 1)",
            }],
        },
        options: {
            maintainAspectRatio: false,
            tooltips: {
                backgroundColor: "rgb(255,255,255)",
                bodyFontColor: "#858796",
                borderColor: '#dddfeb',
                borderWidth: 1,
                xPadding: 15,
                yPadding: 15,
                displayColors: false,
                caretPadding: 10,
            },
            legend: {
                display: false
            },
            cutoutPercentage: 80,
        },
    });
}

$(document).ready(function() {
    var ref = getUrlVars()["c"];
    $('input:file').on("change", function() {
        $('button:submit').show();
    });
    $.ajax({
        type: "POST",
        url: "handlers/api.php",
        data: {
            command: "getBrokerCharts",
            ref:ref
        },
        success: function (data) {
            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === false && result != null) {
                    $('.totAdv').html(result.chart.totalAdv);
                    createChartAdv(result.chart);
                    $('#tableAdvBroker').DataTable({
                        data: result.table,
                        columns: [
                            {
                                'data': 'advTitle'
                            },
                            {
                                'data':'advPrice'
                            },
                            {
                                'data': 'status'
                            },
                            {
                                'data': 'ID_seller'
                            },
                            {
                                "data": 'url',
                                "render": function (data) {
                                    return '<div style="text-align:center;width: 100%"><a href="' + data + '" type="button" style="margin: 0;padding: 3px" class="btn btn-xs" id="' + data + '" ><i class="fas fa-edit" style="color: #3c4859"></i></a></div>'
                                }
                            }
                        ]
                    });
                    traduction();
                }
                else {
                    $('#tableAdvBroker').DataTable({});
                }
            }
        }
    });


    $('.confirmEditBrokerBtn').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> <span data-translate="_loading">Loading</span>...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        var dial = {};
        $(".dialogData").each(function () {
            var i = $(this).val();
            var h = $(this).attr('id');
            if(h === "brokerActivateAccount"){
                if($('input[name="brokerActivateAccount"]').is(':checked')){
                    i=1;
                }
                else{
                    i=0;
                }
            }
            dial[h] = i;
        });

        var info = JSON.stringify(dial);if( result !== info) {

            var csrfToken = $('input[name="CSRFToken"]').val();
            var csrfName = $('input[name="CSRFName"]').val();
            $.ajax({

                type: "POST",
                url: "handlers/api.php",
                data: {
                    command: "editBroker",
                    details: info,
                    CSRFName: csrfName,
                    CSRFToken: csrfToken
                },
                success: function (data) {
                    if (IsJsonString(data) === true) {
                        var data_obj = $.parseJSON(data);
                        var code = data_obj['resultCode'];
                        var error = data_obj['error'];
                        var errorText = data_obj['errorText'];
                        var result = data_obj['result'];
                        if (error === false) {
                            location.reload();
                        }
                        else {
                            $this.html("<span data-translate=\"_confirm\">Confirm</span>>");
                            $('#result').html('<span style="color: #ff0000" data-translate="_error'+code+'">'+errorText+'</span>');
                            traduction();
                        }
                    }
                }
            });
        }
    });

    var form = $("#editBroker");
    $('.deleteImgProfileBtn').click(function () {
        if (form.valid() === true) {
            $('#confirmDeleteBrokerProfileModal').modal('show');
        }
    });


    $('.confirmBrokerBtn').click(function () {
        if (form.valid() === true) {
            $('#confirmEditBrokerModal').modal('show');
        }
    });
    if($("#brokerActivateAccount").is(':checked')){
        $('.radio-default label').html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
        $('#statusBrokerAccount').html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
    }
    else{
        $('#statusBrokerAccount').html('Account <span data-translate="_disabled">Disabled</span>').removeClass('alert-success').addClass('alert-danger');
    }
    $("input[name='brokerActivateAccount']").click(function() {
        traduction();
        $('.radio-default label, #statusBrokerAccount').html('Account <span data-translate="_disabled">Disabled</span>').removeClass('alert-success').addClass('alert-danger');
        if(this.checked){
            $(this ).next().html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
            $('#statusBrokerAccount').html('Account <span data-translate="_enabled">Enabled</span>').removeClass('alert-danger').addClass('alert-success');
        }
        else{

            $('#statusBrokerAccount').html('Account <span data-translate="_disabled">Disabled</span>').removeClass('alert-success').addClass('alert-danger');
        }

    });

    $('.confirmDeleteBrokerProfileBtn').click(function () {
        console.log("porco dio");
        var csrfToken=$('input[name="CSRFToken"]').val();
        var csrfName=$('input[name="CSRFName"]').val();
        var $this = $(this);
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }

        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "delImgBroker",
                ref: ref,
                CSRFName:csrfName,
                CSRFToken:csrfToken
            },
            success: function (data) {
                console.log(data);
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false ) {
                        window.location.reload();
                    }
                    else {
                        $this.html("<span data-translate=\"_confirm\">Confirm</span>");
                        $('#resultDelete').html('<span style="color: #ff0000" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
            }
        });
    })



    // UPLOAD IMAGE

    $("#profileImage").click(function(e) {
        $("#imageUpload").click();
    });

    $("#imageUpload").change(function(){
        fasterPreview( this );
    });

    $('.uploadImgProfile').show();

    $("#uploadProfileImage").on('submit',(function(e) {
        e.preventDefault();
        var csrfToken=$('input[name="CSRFToken"]').val();
        var csrfName=$('input[name="CSRFName"]').val();
        $("#errorImage").empty();
        var formData=new FormData(this);
        formData.append('ref',ref);
        formData.append('command','uploadProfileImage');
        formData.append('CSRFName',csrfName);
        formData.append('CSRFToken',csrfToken);
        var $this = $('.uploadImgProfileBtn');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }

        $.ajax({
            url: "handlers/api.php",
            type: "POST",
            data: formData,
            contentType: false,
            cache: false,
            processData: false,
            error: function () {
                window.location.reload();
            },
            success: function (data) {
                $this.html("Upload");
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false && result != null) {
                        $('.uploadImgProfileBtn').hide();
                        $('.deleteImgProfileBtn').show();
                    }
                    else{
                        $this.removeClass('btn-primary').addClass('btn-warning').html(errorText);
                    }
                }
            }
        });

    }));


});