$(document).ready(function() {
    $.ajax({
        type: "POST",
        url: "handlers/api.php",
        data: {
            command: "tableAdv",

        },
        success: function (data) {
            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === false && result != null) {
                    var table=$('#tableAdv').DataTable({
                        data: result,
                        lengthMenu: [[30, 35, 50, -1], [30, 35, 50, "All"]],
                        columns: [
                            {
                                'data': 'advTitle'
                            },
                            {
                                'data': 'category'
                            },
                            {
                                'data': 'advPrice'
                            },
                            {
                                'data': 'broker'
                            },
                            {
                                'data': 'status'
                            },
                            {
                                "data": 'adv_url',
                                "render": function (data) {
                                    return '<div style="text-align:center;width: 100%"><a href="' + data + '" type="button" style="margin: 0;padding: 3px" class="btn btn-xs" id="' + data + '" ><i class="fas fa-edit" style="color: #3c4859"></i></a></div>'
                                }
                            }
                            ],
                    });
                    $('input[type="search"]').on( 'keyup', function () {
                        traduction()
                    } );

                }
                else{
                    $('#tableAdv').DataTable({});
                }
                traduction();

            }
        }
    });

    var p = getUrlVars()["p"];
    if(p==1){
        /*$('div .dataTables_filter :input[type=search] .form-control .form-control-sm')
            .each(function() {
                $(this).val('app');
            });*/
        $('.dataTables_filter input').val('app');
        console.log(p);
    }


});

