$( document ).ready(function() {
    $(document).on('click', '#newBrokerFromAdv',function (e) {
        e.preventDefault();
        $("#empty-message").html("");
        $('#createBrokerFromAdvModal').modal('show');
    });
    $('#newSellerFromAdv').click(function () {

        $('#createSellerFromAdvModal').modal('show');
    });
    $("#editAdv").validate({
        search: {
            required: true,
        },
        highlight: function(element) {
            $(element).addClass("border-left-danger");
        },
        unhighlight: function(element) {
            $(element).removeClass("border-left-danger");
        }
    });
    $('.setDraft').click( function() {
        $('#confirmSetDraftAdv').modal('show');
    });
    $('.setPending').click( function() {
        $('#confirmSetPendingAdv').modal('show');
    });
    $('.confirmSetDraftAdvBtn').click( function() {
        var i = getUrlVars()["i"];
        var $this = $('.confirmSetDraftAdvBtn');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "setDraft",
                i:i,
            },
            success: function (data) {
                $this.html("<span data-translate=\"_setDraft\">Set Draft</span>");
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    if (error === false ) {
                        location.reload();
                    }
                    else{
                        $('#resultDraft').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
            }
        });
    });
    $('.confirmSetPendingAdvBtn').click( function() {
        var i = getUrlVars()["i"];
        var $this = $('.confirmSetPendingAdvBtn');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "setPending",
                i:i,
            },
            success: function (data) {
                $this.html("<span data-translate=\"_setPending\">Set Pending</span>");
                traduction();
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false && result != null) {
                        location.reload();
                    }
                    else{
                        $('#resultPending').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
            }
        });
    });
    $('#sellerTable').show();
    $('#brokerTable').show();
    var ref = getUrlVars()["i"];

    // Images section
    $('#uploadImages').submit(function (e) {
        e.preventDefault();
        $('.errorUploadText').html("");
        var formData=new FormData(this);
        formData.append('ref_adv',ref);
        formData.append('command','uploadAdvImage');
        var csrfToken=$('input[name="CSRFToken"]').val();
        var csrfName=$('input[name="CSRFName"]').val();
        formData.append('CSRFName',csrfName);
        formData.append('CSRFToken',csrfToken);
        var $this = $('.saveUpload');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        $.ajax({
            url: "handlers/api.php",
            type: "POST",
            data: formData,
            contentType: false,
            cache: false,
            processData: false,
            error: function () {
                window.location.reload();
            },
            success: function (data) {
                $this.html("<span data-translate='_upload'>Upload</span>");
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false ) {
                       location.reload();
                    }
                    else{
                        $('.errorUploadText').html('<span data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }

            }
        });
    });
    $('#uploadImagesSafari').submit(function (e) {
        e.preventDefault();
        $('.errorUploadText').html("");
        var formData=new FormData(this);
        formData.append('ref_adv',ref);
        formData.append('command','uploadAdvImage');
        var csrfToken=$('input[name="CSRFToken"]').val();
        var csrfName=$('input[name="CSRFName"]').val();
        formData.append('CSRFName',csrfName);
        formData.append('CSRFToken',csrfToken);
        var $this = $('.saveUpload');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }$.ajax({
            url: "handlers/api.php",
            type: "POST",
            data: formData,
            contentType: false,
            cache: false,
            processData: false,
            error: function () {
                window.location.reload();
            },
            success: function (data) {
                $this.html("<span data-translate='_upload'>Upload</span>");
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false ) {
                       location.reload();
                    }
                    else{
                        $('.errorUploadText').html('<span data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }

            }
        });
    });
    $('img').on('click', function() {
        $('#overlay')
            .css({backgroundImage: `url(${this.src})`})
            .addClass('open')
            .one('click', function() { $(this).removeClass('open'); });
    });
    $("#uploadedPhoto").DataTable({
        "searching": false,
        responsive: true
    });
    // Detect Safari
    $('.safariDiv').hide();
    $('.upload-text1').html("<span data-translate=\"_dragDrop\"></span>");
    var is_chrome = navigator.userAgent.indexOf('Chrome') > -1;
    var is_safari = navigator.userAgent.indexOf("Safari") > -1;
    if ((is_chrome)&&(is_safari)) { is_safari = false; }
    if(is_safari){
        $('.notSafari').empty();
        $('.safariDiv').show();
        traduction();

    }
    else{
        $('.safariDiv').empty();
    }
    $('.deleteImg').on('click',function () {
        var filename = $(this).attr('id');
        var row=$(this).parent().parent();
        $("#confirmDeleteModal").modal({
            backdrop: 'static',
            keyboard: false
        })
            .on('click', '.confirmDelete', function(e) {
                e.preventDefault();
                if (filename!==null) {
                    $.ajax(
                        {
                            type: "POST",
                            url: "handlers/api.php",
                            data: {
                                command: "deleteImgAdv",
                                filename: filename
                            },
                            success: function (data) {

                                row.remove();
                                filename = null;
                                $("#confirmDeleteModal").modal('hide').clearQueue();
                                $(e).stop(true);
                            }
                        });
                }
            });
    });
    $(".input-images-2").imageUploader({
        maxFiles:6,
        maxSize:5001025
    });
    $('.upload-text').html("<span data-translate='_dragDrop'>Drag & Drop files here or click to browse</span>").addClass('text-center alert-success');



    var form = $("#editAdv");

    $('.confirmNewAdvBtn').click(function () {
        traduction();
        if (form.valid() === true) {
            $('#confirmEditAdvModal').modal('show');
        }
    });

    $('.confirmEditAdvBtn').click(function () {
        var dial = {};
        $(".dialogDataEdit").each(function () {
            var i = $(this).val();
            var h = $(this).attr('id');
            dial[h] = i;
        });
        $(".formData").each(function () {
            var i = $(this).val();
            var h = $(this).attr('id');
            dial[h] = i;
        });
        var showPrice=$('input[name="advShowPrice"]:checked').val();
        var showSeller=$('input[name="advShowSeller"]:checked').val();
        var showBroker=$('input[name="advShowBroker"]:checked').val();
        var groupRadio=$('input[name="gruppoRadio"]:checked').val();
        if(showBroker===undefined){showBroker=0;}else {showBroker=1;}
        if(showSeller===undefined){showSeller=0;}else {showSeller=1;}
        if(showPrice===undefined){showPrice=0;}else {showPrice=1;}

        dial['advShowPrice']=showPrice;
        dial['advShowSeller']=showSeller;
        dial['advShowBroker']=showBroker;
        dial['groupRadio']=groupRadio;

        var $this = $(this);
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> <span data-translate="_loading">Loading</span>...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        var csrfToken = $('input[name="CSRFToken"]').val();
        var csrfName = $('input[name="CSRFName"]').val();
        var infoAdv = JSON.stringify(dial);
        var seller=$('a.nav-link-seller.active').attr('id');
        var broker=$('a.nav-link-broker.active').attr('id');
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "editAdv",
                details: infoAdv,
                adv:ref,
                CSRFName: csrfName,
                CSRFToken: csrfToken,
                seller:seller,
                broker:broker
            },
            success: function (data) {
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (error === false) {
                        location.reload();
                    }
                    else {
                        $this.html("<span data-translate='_confirm'>Confirm</span>");
                        $('#result').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
                else{
                    $this.html("<span data-translate='_confirm'>Confirm</span>");
                }
            }
        });
    });

    traduction();

});

function del(file){
    var filename = file;
    $("#confirmDeleteModal").modal({
        backdrop: 'static',
        keyboard: false
    }).on('click', '.confirmDelete', function(e) {
        e.preventDefault();
        if (filename!==null) {
            $.ajax({
                    type: "POST",
                    url: "handlers/api.php",
                    data: {
                        command: "deleteImgAdv",
                        filename: filename
                    },
                    success: function (data) {
                        location.reload();
                        filename = null;
                        $("#confirmDeleteModal").modal('hide').clearQueue();
                        $(e).stop(true);
                    },
                error: function(){
                    location.reload();
                }

            });
        }
    });
}
