$( document ).ready(function() {





    $('.search-input-broker').autocomplete({
        source: function( request, response ) {
            $.ajax( {
                url: "handlers/api.php",
                type: "POST",
                cache: false,
                async: false,
                data: {
                    searchBroker: request.term,command:"autoCompleteSearchBroker"
                },
                success: function( data ) {
                    if(!data.length){
                        var res = [
                            {
                                label: 'No matches found',
                                value: response.term
                            }
                        ];
                        response(res);
                    }
                    else{
                        console.log(data);
                        if (IsJsonString(data) === true) {
                            var data_obj = $.parseJSON(data);
                            var code = data_obj['resultCode'];
                            var error = data_obj['error'];
                            var errorText = data_obj['errorText'];
                            var result = data_obj['result'];

                            if (code === "111") {
                                location.reload();
                            }
                            if (code === "100") {
                                response(result);
                            }
                            else{

                                var r = [
                                    {
                                        label: errorText,
                                        value: response.term
                                    }
                                ];
                                response(r);
                                traduction();

                            }
                            $('.ui-menu-item').addClass("form-control");
                        }
                    }
                }
            });
        },
        minLength: 3,
        response: function(event, ui) {


            /*
            if (!ui.content.length) {
                var noResult = { value:"123",label:"No results found" };
                $("#empty-message").text("No results found");
                //ui.content.push(noResult);
                traduction();
            }
            else{


            }
            */

        },
        select:function (event,ui) {
            if(ui.item.value !== "No Results.") {
                brokerTable(ui);

                traduction();
            }
        }
    }).autocomplete( "instance" )._renderItem = function( ul, item )
    {
        traduction();

        if(item.value === "No Results."){

            brokerTable();
            s=$("#empty-message").append("<div style='margin-top: 5px'><b><span data-translate='_noResults'>No results.</span></b> <button type='button' class='btn btn-info' id='newBrokerFromAdv'><span data-translate='_addNew'>Add New</span></button></div>");
            return s;
        }
        else{
            string="<div>" + item.label + "</div>";
            return $( "<li>" ).append(string).appendTo(ul);

        }

    };


    jQuery.validator.addMethod("newAdv", function(value) {
        var select = ['defaultGroup'];
        var in_array = $.inArray(value, select);
        if (in_array === -1) {
            return true;
        }else{
            return false;
        }
    }, function () {
        traduction();
        return '<span style="position:absolute;top:0;" data-translate="_required">Required</span>';
    });
    $("#newAdv").validate({
        search: {
            required: true,
        },
        highlight: function(element) {
            $(element).addClass("border-left-danger");
        },
        unhighlight: function(element) {
            $(element).removeClass("border-left-danger");
        }
    });

    var form = $("#newAdv");


    $("#v-pills-tab a.active").attr('id')


    $('.nav-link').click(function() {
        console.log($(this).attr('id'));
    });


    $('.confirmNewAdvBtn').click(function () {
        traduction();
        if (form.valid() === true) {
            $('#confirmCreateAdvModal').modal('show');
        }
    });

    $(document).on('click', '#newBrokerFromAdv',function (e) {
        e.preventDefault();
        $("#empty-message").html("");
        console.log("TEst");
        $('#brokerTable').show();

    });



    $('.confirmCreateAdvBtn').click(function () {
        console.log($('.nav-pills > a.active').attr('id'));
        var dial = {};
        $('#error').val();
        $(".dialogData").each(function () {
            var i = $(this).val();
            var h = $(this).attr('id');
            dial[h] = i;
        });
        var info = JSON.stringify(dial);
        var $this = $(this);
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> <span data-translate="_loading">Loading</span>...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        var csrfToken = $('input[name="CSRFToken"]').val();
        var csrfName = $('input[name="CSRFName"]').val();
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "createAdv",
                details: info,
                CSRFName: csrfName,
                CSRFToken: csrfToken
            },
            success: function (data) {
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (code === "111") {
                        location.reload();
                    }
                    if (error === false) {
                        window.location.href = result;
                    } else {
                        $this.html("<span data-translate='_confirm'>Confirm</span>");
                        $('#result').html('<span style="color: #ff0000" data-translate="_error' + code + '">' + errorText + '</span>');
                        traduction();
                    }
                }
            }
        });
    });



    $(".categoryGroup option[value='defaultGroup']").html('<span data-translate="_choose">Choose </span> <span data-translate="_category">Category</span>');
    $(".categoryType option[value='defaultType']").html('<span data-translate="_choose">Choose </span> <span data-translate="_type">Type</span>');
    getCategoryGroup();
    $('.categoryGroup').change(function () {  getCategoryType($(this).find(':selected').val());});
    traduction();
});

function brokerTable(ui) {
    $('#brokerTable').show();
    if(ui) {
        $('#brokerFirstName').val(ui.item.info.firstName).attr("disabled",true);
        $('#autocompleteE').val(ui.item.info.email);
        $('#brokerEmail').val(ui.item.info.email).attr("disabled",true);
        $('#brokerLastName').val(ui.item.info.lastName).attr("disabled",true);
        $('#brokerCompany').val(ui.item.info.company).attr("disabled",true);
        $('#ref').val(ui.item.ref);
        $('#brokerEmployment').attr("disabled",true);
        $('#brokerEmployment option').each(function () {
            if ($(this).val() === ui.item.info.employment) {
                $(this).prop("selected", true);
            }
        });
    }
    else{
        $('#brokerTable').hide();
        $('#brokerFirstName').val("").prop("disabled",false);
        $('#brokerEmail').val("").prop("disabled",false);
        $('#brokerLastName').val("").prop("disabled",false);
        $('#brokerCompany').val("").prop("disabled",false);
        $('#brokerEmployment').attr("disabled",false);
        $('#ref').val("");
    }

}

function getCategoryGroup() {
    $.ajax(
        {
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "searchCategories",
                group: "all",
            },
            success: function (data) {
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var add = [];
                    var add1 = [];
                    $(data_obj).each(function (key,categories) {
                        $.each(categories,function (key1,category) {
                            if ($.inArray(key1, add) === -1) {
                                add.push(key1);
                                $(".categoryGroup").append($('<option  >', {
                                    value: key1,
                                    html: "<span data-translate='_"+ key1+"'>"+category+"</span>",
                                }));
                            }
                        })
                    });
                }
            }
        });
}
function getCategoryType(id) {
    $(".categoryType").empty();
    $(".categoryGroup option[value='defaultGroup']").remove();
    $(".categoryType").prop("disabled", false);
    $.ajax({
        type: "POST",
        url: "handlers/api.php",
        data: {
            command: "searchCategories",
            group: id,
        },
        success: function (data) {

            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                $(data_obj).each(function () {
                    $(".categoryType").append($('<option>', {
                        value: this.id,
                        html: "<span data-translate='_"+this.id+"'>"+this.name+"</span>",
                    }));
                });
            }
        }
    });
}
