$(document).ready(function() {
    Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
    Chart.defaults.global.defaultFontColor = '#858796';

    $.ajax({
        type: "POST",
        url: "handlers/api_root.php",
        data: {
            command: "getDashboard",
        },
        success: function (data) {
            console.log(data);
            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === false && result != null) {

                    $('.totAdv').html(result.advReport[0].totalAdv);
                    $('.totClient').html(result.clientReport[0].totalClient);
                    $('.totBroker').html(result.brokerReport[0].totalBroker);
                    createChartAdv(result.advReport[0]);
                }
            }
        }
    });

    function createChartAdv(advReport) {
        var advReportDiv = document.getElementById("advReport");
        var myPieChart = new Chart(advReportDiv, {
            type: 'doughnut',
            data: {
                labels: ["Pub", "Non Pub", "Com"],
                datasets: [{
                    data: [advReport.pub,advReport.notPub,advReport.completed],
                    backgroundColor: ['#858796', '#36b9cc','#1cc88a'],
                    hoverBackgroundColor: ['#858796', '#2c9faf', '#17a673'],
                    hoverBorderColor: "rgba(234, 236, 244, 1)",
                }],
            },
            options: {
                maintainAspectRatio: false,
                tooltips: {
                    backgroundColor: "rgb(255,255,255)",
                    bodyFontColor: "#858796",
                    borderColor: '#dddfeb',
                    borderWidth: 1,
                    xPadding: 15,
                    yPadding: 15,
                    displayColors: false,
                    caretPadding: 10,
                },
                legend: {
                    display: false
                },
                cutoutPercentage: 80,
            },
        });
    }
});