<?php

include("csrf.php");

function dateDiffInDays($date1, $date2)
{
    /*$d1 = strtotime($date1);
    $day1=date('Y-m-d', $d1);
    $d2 = strtotime($date2);
    $day2=date('Y-m-d', $d2);*/
    // Calulating the difference in timestamps
    $diff = strtotime($date1) - strtotime($date2);

    // 1 day = 24 hours
    // 24 * 60 * 60 = 86400 seconds
    return abs(round($diff / 86400));
}

function randomPwd() {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.!%_';
    $randomString = '';

    for ($i = 0; $i <= 8; $i++) {
        $index = rand(0, strlen($characters) - 1);
        $randomString .= $characters[$index];
    }

    return $randomString;
}

function encryptPassword($pass,$username)
{
    $s="IkkreaBack";
    $pwd=$pass.$s.$username;
    $t=hash('sha256', $pwd);
    return $t;
}

function isset_username($conn,$username){
    $query = "SELECT `email_validated` FROM `broker` WHERE `email`=?";

    if($stm=$conn->prepare($query))
    {
        $stm->bind_param('s',$username);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($emailValidated);
            $stm->fetch();
            if ($stm->num_rows == 1) {
                $result = array("error" => FALSE, "code" => 100,"Email_validated"=>$emailValidated);
                return $result;
            } else {
                $result = array("error" => TRUE, "code" => 210);
                return $result;
            }
        }
        else {
            $result = array("error" => TRUE, "code" => 413);
            return $result;
        }
    }
    else
    {
        $result = array("error" => TRUE, "code" => 411);
        return $result;
    }
}

function isset_username_adm($conn,$username){
    $query = "SELECT COUNT(*) FROM `rootUser` WHERE `username`=?";

    if($stm=$conn->prepare($query))
    {
        $stm->bind_param('s',$username);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($count);
            $stm->fetch();
            if ($count == 1) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
        else {
            return FALSE;
        }
    }
    else
    {
        return FALSE;
    }
}

function sanitizeName($name){
    $name = preg_replace("/%u([0-9a-f]{3,4})/i", "&#x\\1;", urldecode($name));
    $name = html_entity_decode($name, null, 'UTF-8');
    $name=strtolower($name);
    $name=ucfirst($name);
    return $name ;
}

function getReferral($ID)
{
    $s="tugheda".$ID;
    $t=hash('sha256', $s);
    $referral=substr($t,0,16);
    return $referral;
}

function checkReferral($hash){
    if (preg_match("/^([a-f0-9]{16})$/", $hash) == 1) {
        return true;
    } else {
        return false;
    }
}

function checkSubscription($conn,$id){
    $query="SELECT `date_subscription_expire` FROM `broker` WHERE  `ID_broker`=?";
    if($stm=$conn->prepare($query)){
        $stm->bind_param('i',$id);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($date_expire);
            $stm->fetch();
            $result = array("result" => $date_expire, "error" => FALSE);
            return $result;
        }
        else{
            $result=array("error"=>TRUE,"code"=>413, "result"=>null);
            return $result;
        }
    }
    else{
        $result=array("error"=>TRUE,"code"=>411,"result"=>null);
        return $result;
    }
}

function updateBrokerAdvCounter($id,$code,$now,$conn){
    $dateSubscription=null;
    $date_expire=null;
    $remainingDays=0;
    $advSub=0;
    switch ($code){
        case'1':
            $adv_payed=1;
            break;
        case '2':
            $adv_payed=3;
            break;
        case '3':
            $adv_payed=6;
            break;
        case '4':
            $adv_payed=0;
         /*   $adv_payed=0;
            $remainingDays=31;
            $dateSubscription=$now;
            $advSub=1;
            $dateSubscriptionExpire=checkSubscription($conn,$id);
            if($dateSubscriptionExpire['result']==null){
                $date_expire=date('Y-m-d',strtotime($dateSubscription."+30days"));
            }
            else{
                $date_expire=date('Y-m-d',strtotime($dateSubscriptionExpire['result']."+30days"));;
            }*/
            break;
        case '5':
            $adv_payed=10;
            break;
    }


    //$query="UPDATE broker SET adv_payed=adv_payed+? , adv_sub=?,day_remaining=?,date_subscription=?,date_subscription_expire=?  WHERE  ID_broker=?";
    $query="UPDATE broker SET adv_payed=adv_payed+? WHERE  ID_broker=?";
    if($stm=$conn->prepare($query)){
        //$stm->bind_param('iiissi',$adv_payed,$advSub,$remainingDays,$dateSubscription,$date_expire,$id);
        $stm->bind_param('ii',$adv_payed,$id);
        if($stm->execute()) {
            /*if($code==4){
                $_SESSION['AdvSub'] = 1;;
                $diff=dateDiffInDays($now,$dateSubscription);
                $_SESSION['AdvPublicationDaysRemaining'] = $diff;
                $_SESSION['AdvDateSubscription']=$dateSubscription;
                $_SESSION['subExpire']=$date_expire;
            }*/
            $_SESSION['AdvPublicationRemaining']= $_SESSION['AdvPublicationRemaining']+$adv_payed;
            $result = array("result" => $id, "error" => FALSE);
            return $result;
        }
        else{
            $result=array("error"=>TRUE,"code"=>413, "result"=>$conn->error);
            return $result;
        }
    }
    else{
        $result=array("error"=>TRUE,"code"=>411,"result"=>$conn->error);
        return $result;
    }


}

function issetThx($id,$conn){
    sleep(1);
    if($stm=$conn->prepare("SELECT `thxID` FROM `payments` WHERE `thxID`=? "))
    {
        $stm->bind_param('s',$id);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($thxID);
            $stm->fetch();
            if ($stm->num_rows ==1) {
                $result=array("error"=>false);
                return $result;
            }
            else{
                $result=array("error"=>TRUE,"code"=>210, "result"=>$conn->error);
                return $result;
            }
        }
        else{
            $result=array("error"=>TRUE,"code"=>413, "result"=>$conn->error);
            return $result;
        }
    }
    else{
        $result=array("error"=>TRUE,"code"=>411,"result"=>$conn->error);
        return $result;
    }
}

/*function issetEmail($email,$conn,$dbName){

    switch ($dbName){
        case 'broker':
            $db="broker";
            $id="ID_broker";
            break;
        case 'client':
            $db="client";
            $id="ID_client";
            break;
        case 'seller':
            $db="seller";
            $id="ID_seller";
            break;
    }


    if($stm=$conn->prepare("SELECT $id FROM $db WHERE `email`=? "))
    {
        $stm->bind_param('s',$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($id);
            $stm->fetch();
            if ($stm->num_rows ==1) {
                return $id;
            } else {

                return FALSE;
            }
        }
        else {
            return FALSE;
        }
    }
    else
    {
        return FALSE;
    }
}*/

function issetEmail($email,$conn,$dbName){
    if($stm=$conn->prepare("select(SELECT COUNT(*) FROM `broker` WHERE `email`=?),
                            (select count(*) FROM `seller` WHERE `email`=?),
                            ( select count(*) FROM `client` WHERE `email`=?)"))
    {
        $stm->bind_param('sss',$email,$email,$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($count,$count2,$count3);
            $stm->fetch();
            $tot=$count+$count2+$count3;
            if ($count == 1) {
                return true;

            } else {

                return false;
            }
        }
        else {
            return false;
        }
    }
    else
    {
        return false;
    }
}

function getAdvInfo($i,$conn){
    $id=intval($i);
    if($_SESSION['level']>1){
        $result=array("error"=>TRUE,"code"=>410);
        return $result;
    }
    else {
        if ($_SESSION['level'] == 1) {
            $idBrokerLogged=$_SESSION['ID'];
            $query="SELECT `ID_adv`,`ID_broker`, `ID_seller`, `self_seller`,
                                    `info_adv`,`advPrice`,`advTitle`,`showPrice`,`showSeller`,`showBroker`,
                                    `pending`,`rejected`,`published`,`deleted`,`completed`,`date_public`,`date_creation`
                            FROM `adv` 
                            WHERE `ID_adv`=? AND `ID_broker`='$idBrokerLogged' LIMIT 1";
        } else {
            $query="SELECT `ID_adv`,`ID_broker`, `ID_seller`, `self_seller`,
                                    `info_adv`,`advPrice`,`advTitle`,`showPrice`,`showSeller`,`showBroker`,
                                    `pending`,`rejected`,`published`,`deleted`,`completed`,`date_public`,`date_creation`
                            FROM `adv` 
                            WHERE `ID_adv`=? LIMIT 1";
        }

        if ($stm = $conn->prepare($query)) {
            $stm->bind_param('i', $id);
            if ($stm->execute()) {
                $stm->store_result();
                $stm->bind_result($idAdv,$idBroker,$idSeller,$selfSeller,
                    $advInfo,$advPrice,$advTitle,$showPrice,$showSeller,$showBroker,
                    $adv_pending,$adv_rejected,$adv_IsPublished,$adv_IsDeleted,$adv_IsCompleted,$datePublic,$dateCreation);
                $stm->fetch();
                if ($stm->num_rows === 1) {
                    $_SESSION['temp_ref_adv_info'] = $id;

                    // Comanda completed
                    if ($adv_IsCompleted == 1) {
                        $status = 5;
                        $statusLabel = "<span class='text-success' data-translate='_completed'>Completed</span>";
                    } else {
                        if ($adv_IsPublished == 1) {
                            $status = 4;
                            $statusLabel = " <span class='text-info' data-translate='_published'>Published</span>";
                        } else {
                            if ($adv_rejected == 1) {
                                $status = 3;
                                $statusLabel = "<span class='text-danger' data-translate='_rejected'>Rejected</span>";

                            } else {
                                if ($adv_pending == 1) {
                                    $status = 2;
                                    $statusLabel = "<span class='text-warning' data-translate='_pending'>Pending</span>";

                                } else {
                                    $status = 1;
                                    $statusLabel = "<span class='text-secondary' data-translate='_draft'>Draft</span>";

                                }
                            }
                        }
                    }
                    if($idBroker==0){
                        $selfBroker=1;
                        $brokerInfo = array(
                            "ID"=>0,
                            "Referral"=>0,
                            "Email" => "info@ikkrea.it",
                            "Name" => "Ikkrea"
                        );
                    }
                    else{
                        $selfBroker=0;
                        $broker = getInfo("broker",$idBroker, $conn);
                        $brokerData = json_decode($broker['info'], true);
                        $brokerName=$brokerData['brokerFirstName']." - ".$brokerData['brokerLastName'];
                        $brokerInfo = array(
                            "ID"=>$idBroker,
                            "Referral"=>$broker['referral'],
                            "Email" => $broker['email'],
                            "Name" => $brokerName
                        );
                    }

                    if ($idSeller==0){
                        $selfSeller=1;
                        $sellerInfo = array(
                            "ID"=>0,
                            "Referral"=>0,
                            "Email" => "info@ikkrea.it",
                            "Name" => "Ikkrea"
                        );
                    }
                    else {
                        $seller = getInfo("seller", $idSeller, $conn);
                        $sellerData = json_decode($seller['info'], true);
                        $sellerName = $sellerData['sellerFirstName'] . " - " . $sellerData['sellerLastName'];
                        $sellerInfo = array(
                            "ID" => $idSeller,
                            "Referral" => $seller['referral'],
                            "Email" => $seller['email'],
                            "Name" => $sellerName
                        );
                    }


                    $result=array(
                        "SelfBroker"=>$selfBroker,
                        "ShowBroker"=>$showBroker,
                        "ShowSeller"=>$showSeller,
                        "SelfSeller"=>$selfSeller,
                        "Seller_Info"=>$sellerInfo,
                        "Broker_Info"=>$brokerInfo,
                        "Adv_Info" => $advInfo, "Adv_Title" => $advTitle, "Adv_Price" => $advPrice,"ShowPrice"=>$showPrice,
                        "Adv_date_creation" => $dateCreation,
                        "Adv_date_public" => $datePublic,
                        "status" => $status, "status_label" => $statusLabel
                    );
                    return array("error" => FALSE, "code" => 100, "data" => $result);
                } else {
                    $result = array("error" => TRUE, "code" => 210);
                    return $result;
                }
            } else {
                $result = array("error" => TRUE, "code" => 413);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 411);
            return $result;
        }
    }

}

function getStatusAdv( $id,$conn){
    $query="SELECT `pending`,`rejected`,`published`,`completed` FROM `adv` WHERE `ID_adv`=?";
    if($stm=$conn->prepare($query)){
        $stm->bind_param('i', $id);

        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($adv_pending,$adv_rejected,$adv_IsPublished,$adv_IsCompleted);
            $stm->fetch();
            if ($adv_IsCompleted == 1) {
                $status = 5;
            } else {
                if ($adv_IsPublished == 1) {
                    $status = 4;
                } else {
                    if ($adv_rejected == 1) {
                        $status = 3;
                    } else {
                        if ($adv_pending == 1) {
                            $status = 2;
                        } else {
                            $status = 1;
                        }
                    }
                }
            }
            return array("error" => FALSE, "code" => 100, "result" => $status);
        }
        else {
            $result = array("error" => TRUE, "code" => 413);
            return $result;
        }
    }
    else {
        $result = array("error" => TRUE, "code" => 411);
        return $result;
    }

}

function getInfo($db,$id,$conn){

    switch ($db){
        case 'broker':
            $info="info_broker";
            $idQuery="ID_broker";
            break;
        case 'seller':
            $info="info_seller";
            $idQuery="ID_seller";
            break;
        default:
            $info=null;
    }
    if($info!==null) {

        $query = "SELECT $info,referral,email FROM $db WHERE $idQuery=? LIMIT 1";
        if ($stm = $conn->prepare($query)) {
            $stm->bind_param('i', $id);
            if ($stm->execute()) {
                $stm->store_result();
                $stm->bind_result($info,$referral,$email);
                $stm->fetch();
                if ($stm->num_rows === 1) {
                    return array("info"=>$info,"referral"=>$referral,"email"=>$email);
                } else {
                    return false;
                }
            } else {
                return false;

            }
        } else {
            return false;
        }
    }
    else{
        return false;
    }
}

function getSellerID($email,$conn){
    $query="SELECT `ID_seller` FROM `seller` WHERE `email`=? LIMIT 1";
    if($stm=$conn->prepare($query)){
        $stm->bind_param('s',$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($id);
            $stm->fetch();
            if ($stm->num_rows === 1) {
                $result = array("result" => $id, "error" => FALSE);
                return $result;
            } else {
                $result = array("error" => TRUE, "code" => 210);
                return $result;
            }
        }
        else{
            $result=array("error"=>TRUE,"code"=>413);
            return $result;
        }
    }
    else{
        $result=array("error"=>TRUE,"code"=>411);
        return $result;
    }
}

function getBrokerID($email,$conn){
    $query="SELECT `ID_broker` FROM `broker` WHERE `email`=? LIMIT 1";
    if($stm=$conn->prepare($query)){
        $stm->bind_param('s',$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($id);
            $stm->fetch();
            if ($stm->num_rows === 1) {
                $result = array("result" => $id, "error" => FALSE);
                return $result;
            } else {
                $result = array("error" => TRUE, "code" => 210);
                return $result;
            }
        }
        else{
            $result=array("error"=>TRUE,"code"=>413);
            return $result;
        }
    }
    else{
        $result=array("error"=>TRUE,"code"=>411);
        return $result;
    }
}

function getClientInfo($id,$conn){
    $query="SELECT `info_client`,`profile_img`,`referral`,`email_validated`,`email` FROM `client` where `ID_client`=? LIMIT 1";
    if($stm=$conn->prepare($query)) {
        $stm->bind_param('i', $id);
        if ($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($info,$profileImg,$referral,$emailValidated,$email);
            $stm->fetch();
            if ($stm->num_rows === 1) {
                return array("error"=>FALSE,"info_client" => $info,"profileImgClient"=>$profileImg,"client_email"=>$email,"client_email_validated"=>$emailValidated,"client_referral"=>$referral);
            } else {
                $result = array("error" => TRUE, "code" => 210);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 413);
            return $result;
        }
    }
    else {
        $result = array("error" => TRUE, "code" => 411);
        return $result;
    }
}

function getSellerInfo($id,$conn){
    $query="SELECT `ID_broker`,`info_seller` FROM `seller` where `ID_seller`=? LIMIT 1";
    if($stm=$conn->prepare($query)) {
        $stm->bind_param('i', $id);
        if ($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($ID_broker, $info);
            $stm->fetch();
            if ($stm->num_rows === 1) {
                return array("error"=>FALSE,"ID_broker" => $ID_broker, "info_seller" => $info,"profileImgSeller"=>$imgSrc);
            } else {
                $result = array("error" => TRUE, "code" => 210);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 413);
            return $result;
        }
    }
    else {
        $result = array("error" => TRUE, "code" => 411);
        return $result;
    }
}

function getBrokerInfo($referral,$conn){
    if($_SESSION['level']==1 && $referral!==$_SESSION['referral']){
        $result = array("error" => TRUE, "code" => 410);
        return $result;
    }
    else {
        $ref = substr($referral, 0, 16);
        preg_match('/^[a-zA-Z0-9]+$/', $ref);
        $query = "SELECT `info_broker`,`email`,`last_modify`,`active`,`email_validated`,`profile_img`,`ID_broker`
              
            FROM `broker`  WHERE `broker`.`referral`=?  ORDER BY `broker`.`ID_broker`";
        if ($stm = $conn->prepare($query)) {
            $stm->bind_param('s', $ref);
            if ($stm->execute()) {
                $stm->store_result();
                $stm->bind_result($infoBroker, $email, $lastModify, $active, $emailValidated, $profileImage,$id);
                $stm->fetch();
                if ($stm->num_rows === 1) {
                    $_SESSION['temp_ref_broker_info'] = $referral;
                    $info = json_decode($infoBroker, true);

                    $result = array("error"=>FALSE,"info" => $info, "email" => $email, "lastModify" => $lastModify, "active" => $active,
                        "Email Validated" => $emailValidated,"src" => $profileImage,"id"=>$id);
                    return $result;
                } else {
                    $result = array("error" => $query.$ref, "code" => 210);
                    return $result;
                }
            } else {
                $result = array("error" => TRUE, "code" => 413);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 411);
            return $result;
        }
    }
}

function getPathProfile($user)
{
    $s="ikkreaProfileImageUpload".$user;
    $t=hash('sha256', $s);
    $referral=substr($t,0,16);
    return $referral;
}

function getPathUploadImageAdv($id) {
    $s="ikkreaAdvImageUpload".$id;
    $t=hash('sha256', $s);
    $referral=substr($t,0,16);
    return $referral;
}

function getPhotos($id){

    $ref=getPathUploadImageAdv($id);
    $dir="upload_adv/".$ref;
    $files=scandir($dir,1);
    return $files;
}

function updateProfileBroker($conn,$finalPath,$ref,$level){
    $result=null;
    if($level==1)
    {
        $query = "UPDATE `broker` SET `profile_img`=?,`active`=0,`checked`=0 WHERE  `referral`=?";
        if ($stm = $conn->prepare($query)) {
            $stm->bind_param("ss", $finalPath, $ref);
            if ($stm->execute()) {
                $result = array("error" => FALSE, "code" => 100);
                return $result;
            } else {
                $result = array("error" => TRUE, "code" => 413);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 411);
            return $result;
        }
    }
    else {
        $query = "UPDATE `broker` SET `profile_img`=? WHERE  `referral`=?";
        if ($stm = $conn->prepare($query)) {
            $stm->bind_param("ss", $finalPath, $ref);
            if ($stm->execute()) {
                $result = array("error" => FALSE, "code" => 100);
                return $result;
            } else {
                $result = array("error" => TRUE, "code" => 413);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 411);
            return $result;
        }
    }
}

function getCategories($conn){
    $query="SELECT `ID_category`,`category_group`,`category_type` FROM `categories`";
    if($stm=$conn->prepare($query)){
        if($stm->execute()){
            $stm->store_result();
            $stm->bind_result($id,$group,$type);
            while($stm->fetch()){
                $result[$id]=array("category_group_name"=>$group,"category_type"=>json_decode($type,true));

            }
            $_SESSION['categories']=$result;
            return $result;
        }

        else{
            return 2;
        }
    }
    else{
        return 1;
    }
}

function getOptions($conn){
    $query="SELECT `name`,`value` FROM `options`";
    if($stm=$conn->prepare($query)){
        if($stm->execute()){
            $stm->store_result();
            $stm->bind_result($name,$value);
            while($stm->fetch()){
                $result[$name]=json_decode($value,true);
            }
            return $result;
        }

        else{
            return 2;
        }
    }
    else{
        return 1;
    }

}

function createSeller($conn,$id,$email,$firstName,$lastName,$today,$referral){
    $det=array("sellerFirstName"=>$firstName,"sellerLastName"=>$lastName,"sellerRef"=>$referral,"sellerEmail"=>$email,"sellerDescription"=>"","sellerVat"=>"");
    $details=json_encode($det,true);
    $query="INSERT INTO `seller` (`ID_broker`,`referral`,`email`,`info_seller`,`last_modify`,`date_creation`) VALUES(?,?,?,?,?,?)";
    $stm=$conn->prepare($query);
    $stm->bind_param("isssss",$id,$referral,$email,$details,$today,$today);
    if($stm->execute()){
        return true;
    }
    else{
        return false;
    }
}

function checkOwnerAdvAdmin($idAdv,$conn){
    $query="SELECT `adv`.`ID_broker`,`broker`.`adv_free`,`broker`.`adv_payed`,`adv_sub`,`date_subscription`,`adv`.`advStatus` FROM `adv` INNER JOIN `broker` 
            WHERE `adv`.`ID_broker`=`broker`.`ID_broker` AND `adv`.`ID_adv` =? ";
    if ($stm=$conn->prepare($query)){
        $stm->bind_param("i",$idAdv);
        if($stm->execute()){
            $stm->store_result();
            $stm->bind_result($ID_broker,$advFree,$advPayed,$advSub,$dateSubscription,$advStatus);
            $stm->fetch();

            if($stm->num_rows ==1 ){
                $today = date('Y-m-d H:i:s', time());
                $ts1 = strtotime($today);
                $ts2 = strtotime($dateSubscription);
                $dayremaining=$ts1-$ts2;
                $result = array("error" => FALSE, "code" => 100,
                    "result"=>array("ID_broker"=>$ID_broker,
                        "counterPayed"=>$advPayed,"counterFree"=>$advFree,
                        "advSub"=>$advSub,"dateSubscription"=>$dateSubscription,
                        "advStatus"=>$advStatus,"day_remaining"=>$dayremaining));
                return $result;
            }
            else {
                $result = array("error" => TRUE, "code" => 210);
                return $result;
            }
        }
        else {
            $result = array("error" => TRUE, "code" => 413);
            return $result;
        }
    } else {
        $result = array("error" => TRUE, "code" => 411);
        return $result;
    }

}

function createToken($id,$email,$date)
{
    $t=$id.$email.$date;
    $token=hash('sha256', $t);
    return $token;
}

function updateLogin($conn,$token,$user_id,$email,$type)
{
    switch ($type) {
        case '1':
            $db = "broker";
            $info = "info_broker";
            $id = "ID_broker";
            break;
        case'2':
            $db = "client";
            $info = "info_client";
            $id = "ID_client";
            break;
    }
    $query="UPDATE $db SET `t_login`=? WHERE $id=? AND `email`=?";
    if($pdo=$conn->prepare($query)) {
        $pdo->bind_param('sis', $token, $user_id, $email);
        if($pdo->execute()) {
            if ($pdo->affected_rows == 0) {
                $pdo->close();
                $conn->close();
                return array("error"=>true,"code"=>210);
            } else {
                $pdo->close();
                $conn->close();
                return array("error"=>false,"code"=>100);
            }
        }else {
            return array("error"=>true,"code"=>413,"errorNo"=>$pdo->error);
        }
    }else {
        return array("error"=>true,"code"=>411);
    }
}

function unsetToken($conn,$token)
{
    if($pdo=$conn->prepare("UPDATE `broker` SET `t_login`=NULL WHERE `t_login`=? ")) {
        $pdo->bind_param('s', $token);
        if ($pdo->execute()) {
            if ($pdo->num_rows == 0) {
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }else {
        return false;
    }
}

function isValidToken($token)
{
    if (preg_match("/^([a-f0-9]{64})$/", $token) == 1) {
        return true;
    } else {
        return false;
    }
}

function createSessionUser($token,$info){
    $today = date('Y-m-d H:i:s', time());
    $_SESSION['user'] = $info['$username'];
    $_SESSION['level'] =1;
    $_SESSION['referral'] =$info['referral'];
    $_SESSION['username'] = $info['username'];
    $_SESSION['AdvSub'] = $info['advSub'];
    $_SESSION['ID']=$info['ID'];
    $_SESSION['dateSubscription'] = $info['dateSubscription'];
    $_SESSION['t_login']=$token;
    if($info['advSub']==1){
        $ts1 = strtotime($today);
        $ts2 = strtotime( $info['dateSubscription']);
        $diff=$ts1-$ts2;
        $_SESSION['AdvPublicationDaysRemaining'] = $diff;
        $_SESSION['AdvDateSubscription'];
    }
    else {
        $_SESSION['AdvPublicationRemaining'] = $info['advPayed'] + $info['advFree'];
    }
    $_SESSION['advFree'] = $info['advFree'];
    $_SESSION['AdvPayed'] =  $info['advPayed'];
    $_SESSION['started'] = $_SERVER['REQUEST_TIME'];
    $_SESSION['profileImg']=$info['profileImg'];
}

function issetToken($conn,$token)
{
    if($stm=$conn->prepare("  SELECT  `ID_broker`,`pwd`,`email`,`adv_free`,`adv_payed`,`adv_used`,`referral`,`profile_img`,`date_pwd_change` FROM `broker` WHERE `t_login`=? "))
    {
        $stm->bind_param('s',$token);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($ID, $db_password, $username,$advFree,$advPayed,$advTokenUsed,$referral,$profileImg,$datePwdchange);
            $stm->fetch();
            if ($stm->num_rows == 1) {
                $info=array("ID"=>$ID,"username"=>$username,
                    "advFree"=>$advFree,"advPayed"=>$advPayed,"advUsed"=>$advTokenUsed,"referral"=>$referral,"profileImg"=>$profileImg,"date_pwd_edit"=>$datePwdchange);
                return array("error"=>false,"info"=>$info);

            } else {
                return array("error"=>true,"code"=>210);
            }
        }
        else {
            return array("error"=>true,"code"=>413);
        }
    }
    else
    {
        return array("error"=>true,"code"=>411);
    }
}

function checkOwnerAdv($idAdv,$brokerID,$conn){
    /*$query="SELECT `ID_adv`,`broker`.`adv_free`,`broker`.`adv_payed`,`adv`.`published`,`adv`.`completed`,`adv`.`pending`,`adv_sub`,`date_subscription`,`adv_token_used` FROM `adv` INNER JOIN `broker`
            WHERE `adv`.`ID_broker`=`broker`.`ID_broker` AND `adv`.`ID_adv` =? AND `adv`.`ID_broker`=?";*/
    $query="SELECT `ID_adv`,`broker`.`adv_free`,`broker`.`adv_payed`,`adv`.`published`,`adv`.`completed`,`adv`.`pending`,`adv_sub`,`date_subscription`,`adv_token_used` FROM `adv` INNER JOIN `broker` 
            WHERE `adv`.`ID_broker`=`broker`.`ID_broker` AND `adv`.`ID_adv` =? AND `adv`.`ID_broker`=?";
    if ($stm=$conn->prepare($query)){
        $stm->bind_param("ii",$idAdv,$brokerID);
        if($stm->execute()){
            $stm->store_result();
        $stm->bind_result($id,$advFree,$advPayed,$advPublished,$advCompleted,$advPending,$advSub,$dateSubscription,$adv_token_used);
            $stm->fetch();
            if($stm->num_rows ==1 ){
                $today = date('Y-m-d H:i:s', time());
                $ts1 = strtotime($today);
                $ts2 = strtotime($dateSubscription);
                $dayremaining=$ts1-$ts2;
                $result = array("error" => FALSE, "code" => 100,
                    "result"=>array("id"=>$id,"counterPayed"=>$advPayed,"counterFree"=>$advFree,"completed"=>$advCompleted,"pending"=>$advPending,
                        "published"=>$advPublished,"advSub"=>$advSub,"dateSubscription"=>$dateSubscription,"advTokenUsed"=>$adv_token_used,"day_remaining"=>$dayremaining));
                return $result;
            }
            else {
                $result = array("error" => TRUE, "code" => 210);
                return $result;
            }
        }
        else {
            $result = array("error" => TRUE, "code" => 413);
            return $result;
        }
    } else {
        $result = array("error" => TRUE, "code" => 411);
        return $result;
    }
}

function updateCounter($conn,$counterFree,$counterPayed,$advSub,$brokerID){
    if ($advSub==1){
        $querySub = "UPDATE `broker` SET `adv_used`=`adv_used`+1 WHERE `ID_broker`=?";
        if ($stm = $conn->prepare($querySub)) {
            $stm->bind_param("i", $brokerID);
            if ($stm->execute()) {
                $result = array("error" => FALSE, "code" => 100);
                return $result;
            } else {
                $result = array("error" => TRUE, "code" => 413);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 411);
            return $result;
        }
    }
    else {
        $query = "UPDATE `broker` SET `adv_free`=? ,`adv_payed`=? ,`adv_used`=`adv_used`+1 WHERE `ID_broker`=?";
        if ($stm = $conn->prepare($query)) {
            $stm->bind_param("iii", $counterFree, $counterPayed, $brokerID);
            if ($stm->execute()) {
                $result = array("error" => FALSE, "code" => 100);
                return $result;
            } else {
                $result = array("error" => TRUE, "code" => 413);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 411);
            return $result;
        }
    }

}

function reArrayFiles(&$file_post) {

    $file_ary = array();
    $file_count = count($file_post['name']);
    $file_keys = array_keys($file_post);

    for ($i=0; $i<$file_count; $i++) {
        foreach ($file_keys as $key) {
            $file_ary[$i][$key] = $file_post[$key][$i];
        }
    }

    return $file_ary;
}

function nameFile($tmp){
    $s="ikkreaAdvImageUpload".$tmp;
    $t=hash('sha256', $s);
    $img=substr($t,0,10);
    return $img;
}

function getEmailToken($email,$data)
{
    $s="Ikrrea_Validate".$data.$email;
    $t=hash('sha256', $s);
    return $t;
}

function getAlerts($role){
    $alertsCounter=0;
        if ($role == "admin") {
            if ($_SESSION['alert_pending'] > 0) {
                $alertsCounter++;
                $pending = $_SESSION['alert_pending'];
            }
            if ($_SESSION['alert_rejected'] > 0 && $_SESSION['level']>0 ) {
                $alertsCounter++;
                $rejected = $_SESSION['alert_rejected'];
            }
            if ($_SESSION['alert_contactus'] > 0 && $_SESSION['level']>0 ) {
                $alertsCounter++;
                $contactus = $_SESSION['alert_contactus'];
            }
            $result = array("alerts_counter" => $alertsCounter, "alert_pending" => $pending,"alert_rejected"=>$rejected,"alert_contactus"=>$contactus);
            return $result;
        } else {
            return 0;
        }

}

function getCardAdv($advStatus,$conn){
    if($_SESSION['level']==0) {
        $query = "SELECT `advTitle`,`advPrice`,`date_creation`,`ID_adv`,`info_adv` FROM `adv` WHERE `advStatus`=? AND `deleted`=0 ORDER BY `date_creation` ASC";
    }
    else{
        $user_id=$_SESSION['ID'];
        $query = "SELECT `advTitle`,`advPrice`,`date_creation`,`ID_adv`,`info_adv` FROM `adv` WHERE `advStatus`=? AND `deleted`=0 AND `ID_broker`='$user_id' ORDER BY `date_creation` ASC";
    }
    if($stm=$conn->prepare($query)){
        $stm->bind_param("i", $advStatus);
        if ($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($advTitle,$advPrice,$dateCreation,$ID_adv,$infoAdv);
            if($stm->num_rows >=1 ) {
                while($stm->fetch()) {
                    $url = "a.php?i=" . $ID_adv;
                    $info=json_decode($infoAdv,true);
                    $categoryGroup=$info['categoryGroup'];
                    $categoryType=$info['categoryType'];
                    $district=$info['type'];
                    $cap=$info['cap'];
                    $place=$cap." (".$district.")";
                    foreach ($_SESSION['categories'][$categoryGroup]['category_type'] as $keySingleCat => $singleCat) {
                        if ($singleCat['id'] == $categoryType) {
                            $categoryTypeName = $singleCat['name'];
                        }
                    }
                    $category=ucfirst($_SESSION['categories'][$categoryGroup]['category_group_name']). " - ".ucfirst($categoryTypeName);
                    $data[]=array("Title"=>$advTitle,"Price"=>$advPrice,"Date"=>$dateCreation,"Url"=>$url,"Place"=>$place,"Category"=>$category);
                }
                $result = array("error" => FALSE, "code" => 100,"result"=>$data);
                return $result;
            }
            else{
                $result = array("error" => TRUE, "code" => 210);
                return $result;
            }
        } else {
            $result = array("error" => TRUE, "code" => 413);
            return $result;
        }
    }
    else {
        $result = array("error" => TRUE, "code" => 411,"errCode"=>$conn->error);
        return $result;
    }
}

function day_balance_exists($balance, $array) {
    $result = -1;
    for($i=0; $i<sizeof($array); $i++) {
        if ($array[$i]['day'] == $balance) {
            $result = $i;
            break;
        }
    }
    return $result;
}

function statusAdv($n){

    switch ($n){
        case '1':
            $statusLabel = "<span class='text-secondary' data-translate='_draft'>Draft</span>";
            $statusLabelDatatable = "<b class='text-secondary' data-translate='_draft'>Draft <span hidden>Bozza</span></b>";
            $color="secondary";
            break;
        case '2':
            $statusLabel = "<span class='text-warning' data-translate='_pending'>Pending</span>";
            $statusLabelDatatable = "<b class='text-warning' data-translate='_pending'>Pending  <span hidden>In attesa di approvazione</span></b>";
            $color="warning";
            break;
        case '3':
            $statusLabel = "<span class='text-danger' data-translate='_rejected'>Rejected</span>";
            $statusLabelDatatable =  "<b class='text-danger' data-translate='_rejected'>Rejected  <span hidden>Rifiutata</span></b>";
            $color="danger";
            break;
        case '4':
            $statusLabel = " <span class='text-info' data-translate='_published'>Published</span>";
            $statusLabelDatatable = "<b class='text-info' data-translate='_published'>Published  <span hidden>Pubblicata</span></b>";
            $color="info";
            break;
        case '5':
            $color="success";
            $statusLabel = "<span class='text-success' data-translate='_completed'>Completed</span>";
            $statusLabelDatatable = "<b class='text-success' data-translate='_completed'>Completed  <span hidden>Completata</span></b>";
            break;
        default:
            $statusLabel = "<span class='text-secondary' data-translate='_draft'>Draft</span>";
            $statusLabelDatatable = "<b class='text-secondary' data-translate='_draft'>Draft <span hidden>Bozza</span></b>";
            $color="secondary";
            break;

    }

    return array("color"=>$color,"statusLabel"=>$statusLabel,"statusLabelDatatable"=>$statusLabelDatatable);
}

