<?php
/*csrf*/
function hash_equal($str1, $str2)
{
    if(strlen($str1) != strlen($str2))
    {
        return false;
    }
    else
    {
        $res = $str1 ^ $str2;
        $ret = 0;
        for($i = strlen($res) - 1; $i >= 0; $i--)
        {
            $ret |= ord($res[$i]);
        }
        return !$ret;
    }
}

function csrfguard_start()
{
    if (count($_POST))
    {
        if ( !isset($_POST['CSRFName']) or !isset($_POST['CSRFToken']) )
        {
            //trigger_error("No CSRFName found, probable invalid request.",E_USER_ERROR);
            return "No CSRFName found";
        }
        $name =$_POST['CSRFName'];
        $token=$_POST['CSRFToken'];
        if (!csrfguard_validate_token($name, $token))
        {

            return  "Invalid CSRF token";
        }
        else{
            return $arr=array("name"=>$name,"token"=>$token);
        }
    }
    ob_start();
    /* adding double quotes for "csrfguard_inject" to prevent:
          Notice: Use of undefined constant csrfguard_inject - assumed 'csrfguard_inject' */
    register_shutdown_function("csrfguard_inject");
}


function csrfguard_inject()
{
    $data=ob_get_clean();
    $data=csrfguard_replace_forms($data);
    echo $data;
}






function csrfguard_replace_forms($form_data_html)
{
    $count=preg_match_all("/<form(.*?)>(.*?)<\\/form>/is",$form_data_html,$matches,PREG_SET_ORDER);
    if (is_array($matches))
    {
        foreach ($matches as $m)
        {
            if (strpos($m[1],"nocsrf")!==false) { continue; }
            $name="CSRFGuard_".mt_rand(0,mt_getrandmax());
            $token=csrfguard_generate_token($name);
            $form_data_html=str_replace($m[0],
                "<form{$m[1]}>
                            <input type='hidden' id='CSRFName' name='CSRFName' value='{$name}' />
                            <input type='hidden' id='CSRFToken' name='CSRFToken' value='{$token}' />{$m[2]}
                         </form>",$form_data_html);
        }
    }
    return $form_data_html;
}

function csrfguard_generate_token($unique_form_name)
{
    $token = bin2hex(openssl_random_pseudo_bytes(64)); // PHP 7, or via paragonie/random_compat

    store_in_session($unique_form_name,$token);
    return $token;
}
function csrfguard_validate_token($unique_form_name,$token_value)
{
    $token = get_from_session($unique_form_name);
    if (!is_string($token_value)) {
        return false;
    }
    $result = hash_equal($token, $token_value);

    //unset_session($unique_form_name);
    return $result;
}


function store_in_session($key,$value)
{
    if (isset($_SESSION))
    {
        $_SESSION['CSFR'][$key]=$value;
    }
}
function unset_session($key)
{
    $_SESSION['CSFR'][$key]=' ';
    unset($_SESSION['CSFR'][$key]);
}
function get_from_session($key)
{
    if (isset($_SESSION['CSFR'][$key]))
    {
        return $_SESSION['CSFR'][$key];
    }
    else {  return false; }
}



function getCsfr($sessionCsfrArray)
{
    foreach ($sessionCsfrArray as $key=>$val)
    {
        $data=array("name"=>$key,"token"=>$val);
    }
    return $data;
}



?>
