<?php
session_start();
if(isset($_SESSION['user'])) {
    header("Location: index.php");
}
else {
    require_once("inc/db.inc.php");
    include('inc/function.inc.php');
    ?>
    <html xmlns="http://www.w3.org/1999/html" >
    <head>
        <?php include_once('inc/common_css.php');
        ?>
        <title>Login</title>
    </head>
    <body class="bg-gradient-dark">
    <?php
    csrfguard_start();
    ?>
    <div class="container" style="margin-top: 10vh">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-12 col-md-9">
                <div class="card o-hidden border-0 shadow-lg my-5">
                    <div class="card-body p-0">
                        <div class="row">
                            <div class="col-lg-6 d-none d-lg-block bg-login-image"></div>
                            <div class="col-lg-6">
                                <div class="p-5">
                                    <div class="text-center">
                                        <br>
                                        <h1 class="h4 text-gray-900 mb-4">Login</h1>
                                        <br>
                                    </div>
                                    <form class="user">
                                        <div class="form-group">
                                            <input type="email" class="form-control form-control-user" id="username" aria-describedby="emailHelp" placeholder="Email...">
                                        </div>
                                        <div class="form-group">
                                            <input type="password" class="form-control form-control-user" id="password" autocomplete placeholder="Password">
                                        </div>
                                        <button class="btn btn-primary btn-user btn-block loginBtn">
                                            Login
                                        </button>
                                        <br>
                                        <p class="error" id="result"></p>
                                        <hr>
                                    </form>
                                    <div class="text-center">
                                        <a class="small" href="forgot-pwd.php"><span data-translate="_forgotPassword">Forgot Password?</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </body>
    <footer>
    </footer>
    <?php include('inc/common_js.php');?>
    <script >
        function IsJsonString(str) {
            try {
                JSON.parse(str);
            } catch (e) {
                return false;
            }
            return true;
        }
        $(document).ready(function() {
            $('.loginBtn').on('click',function (e) {
                e.preventDefault();
                var $this = $(this);
                var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
                if ($(this).html() !== loadingText) {
                    $this.data('original-text', $(this).html());
                    $this.html(loadingText);
                }
                $('#result').html("");
                var username=$('#username').val();
                var pwd=$('#password').val();

                if(username !== '' && pwd !== ''){
                    var user=$('#username').val();
                    var pwd=$('#password').val();
                    var csrfToken=$('input[name="CSRFToken"]').val();
                    var csrfName=$('input[name="CSRFName"]').val();
                    $.ajax({
                        type: "POST",
                        url: "handlers/api_root.php",

                        data:{
                            password:pwd,
                            username:user,
                            CSRFName:csrfName,
                            CSRFToken:csrfToken,
                            command:"login"
                        },
                        success: function (data) {
                            if (IsJsonString(data) === true) {
                                var data_obj = $.parseJSON(data);
                                var code = data_obj['resultCode'];
                                var error = data_obj['error'];
                                var errorText = data_obj['errorText'];
                                var result = data_obj['result'];
                                if (error === false) {
                                    window.location.reload();
                                }
                                else {
                                    if (code === 111) {
                                        window.location.reload();
                                    }
                                    else{
                                        $this.html("Login");
                                        $('#result').html(errorText);
                                    }
                                }
                            }
                            else{
                                window.location.reload();
                            }

                        },
                        error:function () {
                            window.location.reload();
                        }
                    });
                }
                else{
                    $('#result').html("Missing Username / Password");
                }
            });
        });
    </script>
    </html>
    <?php
}