<?php
function encryptPassword($pass,$username)
{
    $s="IkkreaBack";
    $pwd=$pass.$s.$username;
    $t=hash('sha256', $pwd);
    return $t;
}

function getEmailToken($email,$data)
{
    $s="Ikrrea_Validate".$data.$email;
    $t=hash('sha256', $s);
    return $t;
}

function updateTokenEmailValidate($email,$conn,$id,$type){
    $today = date('Y/m/d H:i:s', time());
    $tokenEmail=getEmailToken($email,$today);
    switch ($type){
        case '1':
            $db='broker';
            $idName="ID_broker";
            break;
        case'2':
            $db="client";
            $idName="ID_client";
            break;
    }
    $query="UPDATE $db SET email_validate_token=? WHERE $idName=?";
    if($stm=$conn->prepare($query)){
        $stm->bind_param('si',$tokenEmail,$id);
        if($stm->execute()){
            return array("error"=>false,"code"=>100,"token"=>$tokenEmail);
        }
        else {
            return array("error"=>true,"code"=>413);
        }
    }
    else
    {
        return array("error"=>true,"code"=>411);
    }
}

function checkEmailValidated($email,$conn,$delta){
    if($stm=$conn->prepare("SELECT '1' as `type` ,`email_validated`,`email_validate_token`,`ID_broker` FROM `broker` WHERE `email`=? 
                            union SELECT '2' as `type`,`email_validated`,`email_validate_token`,`ID_client` FROM `client` WHERE `email`=? "))
    {
        $stm->bind_param('ss',$email,$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($type,$emailValidated,$emailValidateToken,$id);
            $stm->fetch();
            if ($stm->num_rows == 1) {
                if($emailValidated===1){
                    return array("error"=>true,"code"=>302);
                }
                else {
                    $updateToken=updateTokenEmailValidate($email,$conn,$id,$type);
                    if($updateToken['error']==false) {
                        $e = $id * $delta;
                        $result = array("t" => $updateToken['token'], "e" => $e, "r" => $type);
                        return array("error" => false, "result" => $result);
                    }
                    else{
                        return array("error"=>true,"code"=>$updateToken['code']);
                    }
                }

            } else {
                return array("error"=>true,"code"=>210);
            }
        }
        else {
            return array("error"=>true,"code"=>413);
        }
    }
    else
    {
        return array("error"=>true,"code"=>411);
    }
}

function checkEmail($email,$conn){
    if($stm=$conn->prepare("SELECT '1' as `type`,`ID_broker` FROM `broker` WHERE `email`=? 
                            union SELECT '2' as `type`,`ID_client` FROM `client` WHERE `email`=? "))
    {
        $stm->bind_param('ss',$email,$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($type,$id);
            $stm->fetch();
            if ($stm->num_rows == 1) {
                $result = array("r" => $type,"id"=>$id);
                return array("error" => false, "result" => $result,"code"=>100);
            }
            else {
                return array("error"=>true,"code"=>210);
            }
        }
        else {
            return array("error"=>true,"code"=>413);
        }
    }
    else
    {
        return array("error"=>true,"code"=>411);
    }
}

function issetEmail($email,$conn){
    if($stm=$conn->prepare("SELECT COUNT(*) FROM `broker` WHERE `email`=?
                            union select count(*) FROM `seller` WHERE `email`=?,
                            union select count(*) FROM `client` WHERE `email`=? "))
    {
        $stm->bind_param('sss',$email,$email,$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($count);
            $stm->fetch();
            if ($count == 1) {
                return TRUE;

            } else {

                return FALSE;
            }
        }
        else {
            return FALSE;
        }
    }
    else
    {
        return FALSE;
    }
}

function issetEmailContactUs($email,$conn){
    if($stm=$conn->prepare("SELECT (SELECT '1' as `type`  FROM `broker` WHERE `email`=?), 
                            (SELECT '2' as `type` FROM `client` WHERE `email`=?) ,
                            (SELECT '3' as `type`FROM `seller` WHERE `email`=?)"))
    {
        $stm->bind_param('sss',$email,$email,$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($typeBroker,$typeClient,$typeSeller);
            $stm->fetch();
            if ($stm->num_rows == 1) {
                if($typeSeller!=null){
                    $type=3;
                }
                if($typeClient!=null){
                    $type=2;
                }
                if($typeBroker!=null){
                    $type=1;
                }
                return array("error"=>false,"type"=>$type);

            } else {
                return array("error"=>FALSE,"code"=>210);
            }
        }
        else {
            return array("error"=>true,"code"=>413);
        }
    }
    else
    {
        return array("error"=>true,"code"=>411);
    }
}

function checkEmailType($email,$conn,$type){
    switch ($type){
        case '1':
            $query="SELECT `ID_broker` FROM `broker` WHERE `email`=?";
            break;
        case '2':
            $query="SELECT `ID_client` FROM `client` WHERE `email`=?";
            break;
    }
    if($stm=$conn->prepare($query)) {
        $stm->bind_param('s',$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($id);
            $stm->fetch();
            if($stm->num_rows ==1){
                return $id;
            } else {
                return FALSE;
            }
        }
        else {
            return FALSE;
        }
    }
    else
    {
        return FALSE;
    }
}

function issetEmailLogin($email,$conn){
    if($stm=$conn->prepare("SELECT '1' as `type` ,`pwd`,`ID_broker`,`referral`,`info_broker` FROM `broker` WHERE `email`=? 
                            union SELECT '2' as `type`,`pwd`,`ID_client`,`referral`,`info_client` FROM `client` WHERE `email`=? "))
    {
        $stm->bind_param('ss',$email,$email);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($type,$pwd,$idUser,$referral,$info);
            $stm->fetch();
            if ($stm->num_rows == 1) {
                $det=json_decode($info,true);
                if($type==1){
                    $firstName=$det['brokerFirstName'];
                    $lastName=$det['brokerLastName'];
                }
                else if($type==2){
                    $firstName=$det['clientFirstName'];
                    $lastName=$det['clientLastName'];
                }

                return array("error"=>false,"type"=>$type,"idUser"=>$idUser,"pwdUser"=>$pwd,"referral"=>$referral,"firstName"=>$firstName,"lastName"=>$lastName);

            } else {
                return array("error"=>true,"code"=>210);
            }
        }
        else {
            return array("error"=>true,"code"=>413);
        }
    }
    else
    {
        return array("error"=>true,"code"=>411);
    }
}

function createToken($id,$email,$date)
{
    $t=$id.$email.$date;
    $token=hash('sha256', $t);
    return $token;
}

function updateLogin($conn,$token,$user_id,$email,$type) {
    switch ($type) {
        case'1':
            $db = "broker";
            $info = "info_broker";
            $id = "ID_broker";
            break;
        case'2':
            $db = "client";
            $info = "info_client";
            $id = "ID_client";
            break;
    }
    $query="UPDATE $db SET `t_login`=? WHERE $id=? AND `email`=?";
    if($pdo=$conn->prepare($query)) {
        $pdo->bind_param('sis', $token, $user_id, $email);
        if($pdo->execute()) {
            if ($pdo->affected_rows == 0) {
                $pdo->close();
                $conn->close();
                return array("error"=>true,"code"=>210);
            } else {
                $pdo->close();
                $conn->close();
                return array("error"=>false,"code"=>100);
            }
        }else {
            return array("error"=>true,"code"=>413,"errorNo"=>$pdo->error);
        }
    }else {
        return array("error"=>true,"code"=>411);
    }
}

function emptyToken($conn,$token,$type) {
    switch ($type) {
        case '1':
            $db = "broker";
            $info = "info_broker";
            $id = "ID_broker";
            break;
        case'2':
            $db = "client";
            $info = "info_client";
            $id = "ID_client";
            break;
    }
    if($pdo=$conn->prepare("UPDATE $db SET `t_login`= NULL WHERE `t_login`=? ")) {
        $pdo->bind_param('s', $token);
        if ($pdo->execute()) {

            if ($pdo->affected_rows == 0) {
                $pdo->close();
                $conn->close();
                return FALSE;
            } else {
                $pdo->close();
                $conn->close();
                return TRUE;
            }
        } else {
            return FALSE;
        }
    }else {
        return FALSE;
    }
}

function isValidToken($token){
    if (preg_match("/^([a-f0-9]{64})$/", $token) == 1) {
        return true;
    } else {
        return false;
    }
}

function issetToken($conn,$token)
{
    if($stm=$conn->prepare("  SELECT `ID_client`,`email` FROM `client` WHERE `t_login`=? ")) {
        $stm->bind_param('s',$token);
        if($stm->execute()) {
            $stm->store_result();
            $stm->bind_result($ID_client,$email);
            $stm->fetch();
            if ($stm->num_rows == 1) {
                return array("error"=>false,"ID_client"=>$ID_client,"email"=>$email);
            } else {
                return array("error"=>true,"code"=>210);
            }
        }
        else {
            return array("error"=>true,"code"=>413);
        }
    }
    else
    {
        return array("error"=>true,"code"=>411);
    }
}

function getPathUploadImageAdv($id)
{
    $s="ikkreaAdvImageUpload".$id;
    $t=hash('sha256', $s);
    $referral=substr($t,0,16);
    return $referral;
}

function getEmployment($id,$name,$conn){
    $query="SELECT `value` FROM `options` WHERE `name`=?";
    $stm=$conn->prepare($query);
    $stm->bind_param('s',$name);
    if($stm->execute()) {
        $stm->store_result();
        $stm->bind_result($value);
        $stm->fetch();
        $val=json_decode($value,true);
        foreach ($val as  $key=>$singleValue){
            if($key==$id){
                $result=$singleValue;
            }
        }
        return $result;
    }
}

function getArrayAdvPhoto($id){
    $photos=array();
    $path = getPathUploadImageAdv($id);
    $dir = "../210420/ikkrea_back/upload_adv/" . $path;
    if(file_exists($dir)) {
        $pic = scandir($dir);
        rsort($pic);
        foreach ($pic as $key => $picture) {
            if (!in_array($picture, array(".", ".."))) {
                $photos[] = array("url" => "https://ikkrea.villas.world/handler/img/imgHandler.php?src=" . $path . "/" . $picture);
            }
        }
    }

    if($photos==null){
        $photos=array("url"=>"empty");
    }
    return $photos;
}

function sanitizeName($name){
    $name = preg_replace("/%u([0-9a-f]{3,4})/i", "&#x\\1;", urldecode($name));
    $name = html_entity_decode($name, null, 'UTF-8');
    $name=strtolower($name);
    $name=ucfirst($name);
    return $name ;
}

function getReferral($ID)
{
    $s="tugheda".$ID;
    $t=hash('sha256', $s);
    $referral=substr($t,0,16);
    return $referral;
}

function updateTokenEmail($t,$i,$type,$conn)
{
    switch ($type){
        case '1':
            $updateToken="UPDATE `broker` SET `email_validated`=1,`active`=1, `email_validate_token`= NULL  WHERE `email_validate_token`=? AND  `ID_broker`=?";

            break;
        case'2':
            $updateToken="UPDATE `client` SET `email_validated`=1,`active`=1, `email_validate_token`= NULL  WHERE `email_validate_token`=? AND  `ID_client`=?";
            break;
    }

    if($stm2=$conn->prepare($updateToken)){
        $stm2->bind_param('si', $t, $i);
        if($stm2->execute()){
            $stm2->close();
            $conn->close();
            return 1;
        }
        else{
            $stm2->close();
            $conn->close();
            return 5;
        }
    }
    else
    {

        $stm2->close();
        $conn->close();
        return 2;
    }
}

function createSeller($conn,$id,$email,$firstName,$lastName,$today,$referral){
    $det=array("sellerFirstName"=>$firstName,"sellerLastName"=>$lastName,"sellerRef"=>$referral,"sellerEmail"=>$email,"sellerDescription"=>"","sellerVat"=>"");
    $details=json_encode($det,true);
    $query="INSERT INTO `seller` (`ID_broker`,`referral`,`email`,`info_seller`,`last_modify`,`date_creation`) VALUES(?,?,?,?,?,?)";
    $stm=$conn->prepare($query);
    $stm->bind_param("isssss",$id,$referral,$email,$details,$today,$today);
    if($stm->execute()){
        return true;
    }
    else{
        return false;
    }
}

function getSellerInfo($id,$conn){
    $query="SELECT `info_seller` FROM `seller` where `ID_seller`=? LIMIT 1";
    if($stm=$conn->prepare($query)){
        $stm->bind_param('i',$id);
        if($stm->execute()){
            $stm->store_result();
            $stm->bind_result($info);
            $stm->fetch();
            if ($stm->num_rows === 1) {
                return $info;
            }
            else{
                return false;
            }
        }
        else{
            return false;

        }
    }
    else{
        return false;
    }
}

function getBrokerInfo($id,$conn){
    $query="SELECT `info_broker` FROM `broker` where `ID_broker`=? LIMIT 1";
    if($stm=$conn->prepare($query)){
        $stm->bind_param('i',$id);
        if($stm->execute()){
            $stm->store_result();
            $stm->bind_result($info);
            $stm->fetch();
            if ($stm->num_rows === 1) {
                return $info;
            }
            else{
                return false;
            }
        }
        else{
            return false;

        }
    }
    else{
        return false;
    }
}

$varCustom=array("name"=>"Ikkrea",
    "url"=>"https://www.ikkrea.it",
    "reg_url"=>"https://ikkrea.villas.world",
    "siteName"=>"ikkrea.com",
    "phone"=>"+45 123456789",
    "facebook"=>"https://www.facebook.com",
    "twitter"=>"https://twitter.com/",
    "linkedin"=>"https://www.linkedin.com",
    "youtube"=>"https://www.youtube.com/",
    "telegram"=>"https://t.me/",
    "github"=>"github",
    "medium"=>"medium",
    "supportEmail"=>"support@ikkrea.it",
    "infoEmail"=>"info@demo.io",
    "privateEmail"=>"private@ikkrea.it",
    "privacyPolicy"=>"https://www.ikkrea.it",
    "legalTerms"=>"https://www.ikkrea.it",
    "description" => "",
    "themeColor"=>"#005C97");