<!-- Confirm Modal-->
<div class="modal fade" id="product4Modal" tabindex="-1" role="dialog" aria-labelledby="product4Modal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content border-left-danger">
            <div class="modal-header">
                <h5 class="modal-title text-danger"><b data-translate="_confirm">Confirm</b> <span data-translate="_purchase">Purchase</span></h5>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <b aria-hidden="true">×</b>
                </button>
            </div>
            <div class="payments-3-loading text-center text-gray-800"></div>
            <div class="modal-body payments-3 text-gray-800">
                <p data-translate="_sure" >Are you sure?</p>
                <span data-translate="_confirmBuy">You decided to buy</span> <span data-translate="_sub">sub</span> <span data-translate="_monthly">Monthly</span>
                <br><br>
                <div class="text-center h3 mb-0 font-weight-bold ">€300,00</div>
                <p id="result"></p>
            </div>
            <div class="modal-body">
                <div id="paypal-button-container-4"></div>
                <script>
                    paypal.Buttons({
                        style: {
                            shape: 'rect',
                            color: 'silver',
                            layout: 'horizontal',
                            label: 'paypal',
                            tagline: false
                        },
                        createOrder: function(data, actions) {
                            $('.payments-4').hide();
                            $('.payments-4-loading').html("<div class=\"payment-3-spinner spinner-border text-danger mb-5\" style='margin: 50px;' role=\"status\">\n" +
                                "  <span class=\"sr-only\">Loading...</span>\n" +
                                "</div>");

                            return actions.order.create({
                                purchase_units: [{
                                    amount: {
                                        value: '300'
                                    }
                                }]
                            });
                        },
                        onCancel: function (data, actions) {
                            location.reload();
                        },
                        onError: function(error) {
                            location.reload();
                        },
                        onApprove: function(data, actions) {
                            return actions.order.capture().then(function(details) {
                                $.ajax({
                                    type: "POST",
                                    url: "handlers/api.php",
                                    data: {
                                        command: "addPayment",
                                        details:details,
                                        code:4
                                    },
                                    success: function (data) {
                                        $('.payments-4').show();
                                        $('.payment-4-spinner').hide();
                                        $('#product4Modal').modal('hide');
                                        var data_obj = $.parseJSON(data);
                                        var code = data_obj['resultCode'];
                                        var error = data_obj['error'];
                                        var errorText = data_obj['errorText'];
                                        var result = data_obj['result'];
                                        if (error === false) {
                                            window.location.href=result;
                                        }
                                        else {
                                            $('#result').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                                            traduction();
                                        }
                                    }
                                });
                            });
                        }
                    }).render('#paypal-button-container-4');
                </script>
            </div>
        </div>
    </div>
</div>
