<!-- Confirm Modal-->
<div class="modal fade" id="product1Modal" tabindex="-1" role="dialog" aria-labelledby="product1Modal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content border-left-primary">
            <div class="modal-header">
                <h5 class="modal-title text-primary" id="product1Modal" data-translate="_confirm"><b>Confirm</b></h5>
                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class=" payments-1-loading text-center text-gray-800">
            </div>
            <div class=" payments-1 text-gray-800" style="margin: 40px">
                <div class="modal-body">
                    <p data-translate="_sure">Are you sure?</p>
                    <span data-translate="_confirmBuy">You decided to buy</span> 1 <span data-translate="_adv">Adv</span>
                    <br><br>
                    <div class="text-center h3 mb-0 font-weight-bold ">€50,00</div>

                    <p id="result"></p>
                </div>
            </div>
            <div class="modal-body">
            <div class="payments-1">
                <div id="paypal-button-container-1"></div>
                <script src="https://www.paypal.com/sdk/js?client-id=sb&currency=EUR" data-sdk-integration-source="button-factory"></script>
                <script>
                    paypal.Buttons({
                        style: {
                            shape: 'rect',
                            color: 'silver',
                            layout: 'horizontal',
                            label: 'paypal',
                            tagline: false
                        },
                        createOrder: function(data, actions) {
                            $('.payments-1').hide();
                            $('.payments-1-loading').html("<div class=\"payment-1-spinner spinner-border text-primary mb-5\" style='margin: 50px;' role=\"status\">\n" +
                                "  <span class=\"sr-only\">Loading...</span>\n" +
                                "</div>");

                            return actions.order.create({
                                purchase_units: [{
                                    amount: {
                                        value: '50'
                                    }
                                }]
                            });
                        },
                        onCancel: function (data, actions) {
                            location.reload();
                        },
                        onError: function(error) {
                            location.reload();
                        },
                        onApprove: function(data, actions) {
                            return actions.order.capture().then(function(details) {
                                $.ajax({

                                    type: "POST",
                                    url: "handlers/api.php",
                                    data: {
                                        command: "addPayment",
                                        details:details,
                                        code:1
                                    },
                                    success: function (data) {

                                        $('.payments-1').show();
                                        $('.payments-1-loading').hide();
                                        var data_obj = $.parseJSON(data);
                                        var code = data_obj['resultCode'];
                                        var error = data_obj['error'];
                                        var errorText = data_obj['errorText'];
                                        var result = data_obj['result'];
                                        if (error === false) {
                                            window.location.href=result;
                                        }
                                        else {
                                            $('#result').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                                            traduction();
                                        }
                                    }
                                });
                            });
                        }
                    }).render('#paypal-button-container-1');
                </script>
            </div>
            </div>
        </div>
    </div>
</div>
