$(document).ready(function() {

    $("#newClient").validate({
        rules: {
            email: {
                required: true,
                email: true,
            },
            firstName: {
                required: true,
                minlength: 2
            },
            lastName: {
                required: true,
                minlength: 2
            }
        },
        highlight: function(element) {
            $(element).addClass("border-left-danger");
            traduction();
        },
        unhighlight: function(element) {
            $(element).removeClass("border-left-danger");
            traduction();
        },

    });
    var form = $("#newClient");
    $('.confirmClientBtn').click(function () {

        if (form.valid() === true) {
            $('#confirmCreateClientModal').modal('show');
        }
    });
    $('.confirmCreateClientBtn').click(function () {
        var dial = {};
        var btnId=$(this).attr('id');
        $('#error').val();
        $(".dialogDataClient").each(function () {
            var i = $(this).val();
            var h = $(this).attr('id');
            dial[h] = i;
        });
        var info = JSON.stringify(dial);

        var csrfToken = $('input[name="CSRFToken"]').val();
        var csrfName = $('input[name="CSRFName"]').val();
        $.ajax({

            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "createClient",
                details: info,
                CSRFName: csrfName,
                CSRFToken: csrfToken,
                btnId:btnId
            },
            success: function (data) {
                console.log(data);
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (code === "111") {
                    location.reload();
                }
                if (error === false) {
                    if(result.from !== "adv") {
                        window.location.href = result.data;
                    }
                    else{
                        $('#createClientFromAdvModal').modal('hide');
                        $('#confirmCreateClientModal').modal('hide');
                    }
                }


                else {
                    $('#result').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                    traduction();
                }
            }
        });
    });
});