$( document ).ready(function() {


    $('.search-input-seller').autocomplete({
        source: function( request, response ) {
            $.ajax( {
                url: "handlers/api.php",
                type: "POST",
                cache: false,
                async: false,
                data: {
                    searchSeller: request.term,command:"autoCompleteSearchSeller"
                },
                success: function( data ) {
                    if(!data.length){
                        var res = [
                            {
                                label: 'No matches found',
                                value: response.term
                            }
                        ];
                        response(res);
                    }
                    else{
                        if (IsJsonString(data) === true) {
                            var data_obj = $.parseJSON(data);
                            var code = data_obj['resultCode'];
                            var error = data_obj['error'];
                            var errorText = data_obj['errorText'];
                            var result = data_obj['result'];

                            if (code === "111") {
                                location.reload();
                            }
                            if (code === "100") {
                                response(result);
                            }
                            else{

                                var r = [{
                                    label: errorText,
                                    value: response.term
                                }];
                                response(r);
                                traduction();

                            }
                            $('.ui-menu-item').addClass("form-control");
                        }
                    }
                }
            });
        },
        minLength: 3,
        response: function(event, ui) {

        },
        select:function (event,ui) {
            if(ui.item.value !== "No Results.") {
                sellerTable(ui);

                traduction();
            }
        }
    }).autocomplete( "instance" )._renderItem = function( ul, item ) {
        traduction();
        if(item.value === "No Results."){
            $("#empty-message-seller").html("");
            $('#sellerTable').hide();
            s=$("#empty-message-seller").append("<div style='margin-top: 10px'><b><span data-translate='_noResults'>No results.</span></b></div>");
            return s;
        }
        else{
            string="<small>" + item.label + "</small> ";
            return $( "<li>" ).append(string).appendTo(ul);
        }
    };


});

function sellerTable(ui) {
    $('#sellerTable').show();
    $( ".nav-link-seller#2 ").trigger( "click" );

    if(ui) {

        $('#sellerFirstName').val(ui.item.info.sellerFirstName).attr("disabled",true);
        $('#autocompleteSeller').val(ui.item.info.sellerEmail);
        $('#sellerEmail').val(ui.item.value).attr("disabled",true);
        $('#sellerLastName').val(ui.item.info.sellerLastName).attr("disabled",true);
    }
}