$( document ).ready(function() {





    jQuery.validator.addMethod("newAdv", function(value) {
        var select = ['defaultGroup'];
        var in_array = $.inArray(value, select);
        if (in_array === -1) {
            return true;
        }else{
            return false;
        }
    }, function () {
        traduction();
        return '<span style="position:absolute;top:0;" data-translate="_required">Required</span>';
    });

    $("#newAdv").validate({
        search: {
            required: true,
        },
        highlight: function(element) {
            $(element).addClass("border-left-danger");
        },
        unhighlight: function(element) {
            $(element).removeClass("border-left-danger");
        }
    });

    var form = $("#newAdv");


    $("#v-pills-tab a.active").attr('id');


    $('.confirmNewAdvBtn').click(function () {
        traduction();
        if (form.valid() === true) {

            $('#confirmCreateAdvModal').modal('show');
        }
    });

    $(document).on('click', '#newBrokerFromAdv',function (e) {
        e.preventDefault();
        $("#empty-message").html("");
        $('#createBrokerFromAdvModal').modal('show');
    });
    $('#newSellerFromAdv').click(function () {
        $('#createSellerFromAdvModal').modal('show');
    });

    $('.confirmCreateAdvBtn').click(function () {
        var seller=$('a.nav-link-seller.active').attr('id');
        var broker=$('a.nav-link-broker.active').attr('id');
        var dial = {};
        $('#error').val();
        $(".formData").each(function () {
            var i = $(this).val();
            var h = $(this).attr('id');
            dial[h] = i;
        });
        var infoAdv = JSON.stringify(dial);
        var emailBroker = $('.brokerData').val();
        var emailSeller= $('.sellerData').val();
        var $this = $(this);
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> <span data-translate="_loading">Loading</span>...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        var csrfToken = $('input[name="CSRFToken"]').val();
        var csrfName = $('input[name="CSRFName"]').val();
        console.log(infoAdv);
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "createAdv",
                details: infoAdv,
                emailSeller:emailSeller,
                emailBroker:emailBroker,
                CSRFName: csrfName,
                CSRFToken: csrfToken,
                seller:seller,
                broker:broker
            },
            success: function (data) {
                console.log(data);
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    var result = data_obj['result'];
                    if (code === "111") {
                        location.reload();
                    }
                    if (error === false) {
                        window.location.href = result;
                    } else {
                        $this.html("<span data-translate='_confirm'>Confirm</span>");
                        if(code === "402"){
                            $('#result').html('<span style="color: #ff0000" data-translate="_choose">Choose</span> <span style="color: #ff0000" data-translate="_'+result+'">' + result + '</span>');
                        }
                        else {
                            $('#result').html('<span style="color: #ff0000" data-translate="_error' + code + '">' + errorText + '</span>');
                        }
                        traduction();
                    }
                }
            }
        });
    });
    $(".categoryGroup option[value='defaultGroup']").html('<span data-translate="_choose">Choose </span> <span data-translate="_category">Category</span>');
    $(".categoryType option[value='defaultType']").html('<span data-translate="_choose">Choose </span> <span data-translate="_type">Type</span>');
    getCategoryGroup();
    $('.categoryGroup').change(function () {
        getCategoryType($(this).find(':selected').val());});
    traduction();
});

function brokerTable(ui) {
    $('#brokerTable').show();
    if(ui) {
        $( ".nav-link-broker#2 ").trigger( "click" );
        $('#brokerFirstName').val(ui.item.info.brokerFirstName).attr("disabled",true);
        $('#autocompleteE').val(ui.item.info.email);
        $('#brokerEmail').val(ui.item.info.brokerEmail).attr("disabled",true);
        $('#brokerLastName').val(ui.item.info.brokerLastName).attr("disabled",true);
        $('#ref').val(ui.item.ref);
    }
}

function getCategoryGroup() {
    $.ajax(
        {
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "searchCategories",
                group: "all",
            },
            success: function (data) {
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var add = [];
                    var add1 = [];
                    $(data_obj).each(function (key,categories) {
                        $.each(categories,function (key1,category) {
                            if ($.inArray(key1, add) === -1) {
                                add.push(key1);
                                $(".categoryGroup").append($('<option  >', {
                                    value: key1,
                                    html: "<span data-translate='_"+ key1+"'>"+category+"</span>",

                                }));
                            }
                        })
                    });
                    getCategoryType($('.categoryGroup').find(':selected').val());
                }
            }
        });
}
function getCategoryType(id) {
    $(".categoryType").empty();
    $(".categoryGroup option[value='defaultGroup']").remove();
    $(".categoryType").prop("disabled", false);
    $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "searchCategories",
                group: id,
            },
            success: function (data) {
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    $(data_obj).each(function () {
                        $(".categoryType").append($('<option>', {
                            value: this.id,
                            html: "<span data-translate='_"+this.id+"'>"+this.name+"</span>",
                        }));
                    });
                }
            }
    });
}

