$( document ).ready(function() {

    var myData;
    var onCityChange = function (e) {
        var cityData = $("option:selected", e.target).data('code');
        $("#code").val(cityData.code);

    };
    var onStateChange = function (e) {
        var state = $("option:selected", e.target).text();

        if (state && myData) {
            var stateData = myData[state];
            if (stateData && stateData.length > 0) {
                $("#advCity").empty();
                $("#advCity").unbind('change');
                for (var i =0 ; i < stateData.length; i++) {
                    var cityData = stateData[i];
                    var option = $('<option value="' + cityData.code + '">' + cityData.name + '</option>').data('code', cityData);
                    $("#advCity").append(option);
                }
                $("#advCity").bind('change', onCityChange)
                    .trigger('change');
            }
        }
    };

    $.ajax({
        url: 'places/places.json',
        dataType: 'json',
        success: function (data) {

            var stateOptions = "", stateId = 1;
            for (var prop in data) {
                if (data.hasOwnProperty(prop)) {
                    stateOptions += '<option value="' + stateId + '">' + prop + '</option>';
                    stateId++;
                }
            }
            myData = data;
            $("#advDistrict").html(stateOptions);
            var cap=$('#cap').val();
            var district=$('#district').val();
            if(district){
                $("#advDistrict").val(district).bind('change', onStateChange)
                    .trigger('change');
                if(cap){
                    $("#advCity").val(cap).bind('change', onCityChange)
                        .trigger('change');
                }
            }
            else{
                $("#advDistrict").val(district).bind('change', onStateChange)
                    .trigger('change');
            }
        }
    });


    $('.search-input-seller').autocomplete({
        source: function( request, response ) {
            $.ajax( {
                url: "handlers/api.php",
                type: "POST",
                cache: false,
                async: false,
                data: {
                    searchSeller: request.term,command:"autoCompleteSearchSeller"
                },
                success: function( data ) {
                    if(!data.length){
                        var res = [
                            {
                                label: 'No matches found',
                                value: response.term
                            }
                        ];
                        response(res);
                    }
                    else{
                        if (IsJsonString(data) === true) {
                            var data_obj = $.parseJSON(data);
                            var code = data_obj['resultCode'];
                            var error = data_obj['error'];
                            var errorText = data_obj['errorText'];
                            var result = data_obj['result'];

                            if (code === "111") {
                                location.reload();
                            }
                            if (code === "100") {
                                response(result);
                            }
                            else{

                                var r = [{
                                    label: errorText,
                                    value: response.term
                                }];
                                response(r);
                                traduction();

                            }
                            $('.ui-menu-item').addClass("form-control");
                        }
                    }
                }
            });
        },
        minLength: 3,
        response: function(event, ui) {

        },
        select:function (event,ui) {
            if(ui.item.value !== "No Results.") {
                sellerTable(ui);
                traduction();
            }
        }
    }).autocomplete( "instance" )._renderItem = function( ul, item ) {
        traduction();
        if(item.value === "No Results."){
            $("#empty-message-seller").html("");
            $('#sellerTable').hide();
            s=$("#empty-message-seller").append("<div style='margin-top: 10px'><b><span data-translate='_noResults'>No results.</span></b></div>");
            return s;
        }
        else{
            string="<small>" + item.label + "</small> ";
            return $( "<li>" ).append(string).appendTo(ul);
        }
    };

    if($("input[name='advShowPrice']").is(':checked')){
        $('.radio-default label').html('<span data-translate="_showPrice">Show Price</span>').removeClass('alert-danger').addClass('alert-success');
    }
    $("input[name='advShowPrice']").click(function() {
        $('.radio-default label').html('<span data-translate="_notShowPrice">Price Hidden</span>').removeClass('alert-success').addClass('alert-danger');
        if(this.checked) {
            $(this).next().html('<span data-translate="_showPrice">Show Price</span>').removeClass('alert-danger').addClass('alert-success');
        }
        traduction();

    });
    if($("input[name='advShowBroker']").is(':checked')){
        $('.radio-showbroker label').html('<span data-translate="_show">Show</span> <span data-translate="_broker">Broker</span>').removeClass('alert-danger').addClass('alert-success');

    }
    $("input[name='advShowBroker']").click(function() {

        $('.radio-showbroker label').html('<span data-translate="_hide">Hide</span> <span data-translate="_broker">Broker</span>').removeClass('alert-success').addClass('alert-danger');
        if(this.checked){
            $(this ).next().html('<span data-translate="_show">Show</span> <span data-translate="_broker">Broker</span>').removeClass('alert-danger').addClass('alert-success');
        }
        traduction();
    });
    if($("input[name='advShowSeller']").is(':checked')){
        $('.radio-showseller label').html('<span data-translate="_show">Show</span> <span data-translate="_seller">Seller</span>').removeClass('alert-danger').addClass('alert-success');
    }
    $("input[name='advShowSeller']").click(function() {
        $('.radio-showseller label').html('<span data-translate="_hide">Hide</span> <span data-translate="_seller">Seller</span>').removeClass('alert-success').addClass('alert-danger');
        if(this.checked){
            $(this ).next().html('<span data-translate="_show">Show</span> <span data-translate="_seller">Seller</span>').removeClass('alert-danger').addClass('alert-success');
        }
        traduction();

    });

});

function sellerTable(ui) {
    $('#sellerTable').show();
    $( ".nav-link-seller#2 ").trigger( "click" );

    if(ui) {
        $('#sellerName').val(ui.item.info.name).attr("disabled",true);
        $('#autocompleteSeller').val(ui.item.info.email);
        $('#sellerEmail').val(ui.item.value).attr("disabled",true);
    }
}