<?php
ini_set('display_errors', 1);

session_start();
header("Access-Control-Allow-Origin: *");
header('Access-Control-Allow-Credentials: true');
header("Access-Control-Allow-Methods: *");
header("Access-Control-Allow-Headers: content-type,X-Custom-Information, authorization");

include "../inc/db.inc.php";
include "../inc/function.inc.php";


$level=$_SESSION['level'];
if (0 === strpos($_SERVER['CONTENT_TYPE'], 'application/json')) {
    $_POST = json_decode(file_get_contents('php://input'), true);
}


$data=null;
if (!empty($_POST)) {
    $command = $_POST['command'];
    if (isset($_POST['command'])) {
        switch ($command) //switch case command
        {
            case 'login':
                if (!isset($_SESSION['user']))
                {
                    if (!empty($_POST['username'] AND $_POST['password'])) {
                        $c=csrfguard_start();
                        if ($c!== "No CSRFName found" && $c!== "Invalid CSRF token.") {
                            $username = stripslashes(strtolower($_POST['username']));
                            $password = stripslashes($_POST['password']);
                            $passCrypted = encryptPassword($password, $username);
                            if (isset_username_adm($conn, $username)) {
                                $query = "SELECT `ID`,`password`,`level`,`username` FROM `rootUser` WHERE `password`=? LIMIT 1";
                                if ($login = $conn->prepare($query)) {
                                    $login->bind_param("s", $passCrypted);
                                    if ($login->execute()) {
                                        $login->store_result();
                                        $login->bind_result($ID, $db_password, $level, $username);
                                        $login->fetch();
                                        if ($login->num_rows == 1) {
                                            if ($passCrypted === $db_password) {
                                                $_SESSION['user'] = $username;
                                                $_SESSION['level'] = 0;
                                                $_SESSION['referral'] = "admin";
                                                $_SESSION['username'] = $username;
                                                $_SESSION['started'] = $_SERVER['REQUEST_TIME'];
                                                $_SESSION['ID'] = $ID;
                                                $options = getOptions($conn);
                                                $_SESSION['options_employment']= $options['employment'];
                                                $response = appendData($_SESSION, '100', FALSE);
                                                echo $json = json_encode($response);
                                            } else {
                                                sleep(1);
                                                $response = appendData($data, '201', TRUE);
                                                echo $json = json_encode($response);
                                            }
                                        } else {
                                            sleep(1);
                                            $response = appendData($data, '210', TRUE);
                                            echo $json = json_encode($response);
                                        }
                                    } else {
                                        sleep(1);
                                        $response = appendData("username", '413', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                } else {
                                    sleep(1);
                                    $response = appendData("username", '411', TRUE);
                                    echo $json = json_encode($response);
                                }
                            } else {
                                sleep(1);
                                $response = appendData("username", '204', TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                        else
                        {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else{
                        $response = appendData($_POST, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '113', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'logout':
                session_destroy();
                exit();
                break;
            case 'getDashboard':
                if($_SESSION['level']==0){
                    // adv
                    $draft=0;
                    $queryAdv="SELECT count(nullif(`published` = false, true)) as `pub`,
                                      count(nullif(`published` = true, true)) as `notPub`, 
                                      count(nullif(`completed` = false, true )) as `completed`,
                                      count(nullif(`rejected` = false, true )) as `rejected`,
                                      count(nullif(`pending` = false, true )) as `pending`,                                     
                                      count(`published`) as totalRows
                               FROM `adv`";
                    $stm=$conn->prepare($queryAdv);
                    $stm->execute();
                    $stm->store_result();
                    $stm->bind_result($pub,$notPub,$completed,$rejected,$pending,$totalRows);
                    $stm->fetch();
                    $draft=$totalRows-$completed-$pub-$rejected-$pending;
                    $_SESSION['alert_pending']=$pending+0;
                    $_SESSION['alert_rejected']=$rejected+0;
                    $advReport[]=array("pub"=>$pub,"draft"=>$draft,"completed"=>$completed,"rejected"=>$rejected,"pending"=>$pending,
                        "totalAdv"=>$totalRows);
                    $stm->close();

                    $queryNumbers= "select(	SELECT COUNT(*) FROM `broker`as brokers ),
    	                            (SELECT COUNT(*) FROM `client` as clients),
    	                            (SELECT COUNT(*) FROM `seller`as sellers),
    	                            (SELECT SUM(`amount`) FROM `payments` as totPayments),
    	                            (SELECT SUM(`adv_payed`) FROM `broker` as totAdvPayed where `ID_broker`!=1 ),
    	                            (SELECT COUNT(`ID_payment`) FROM `payments` where `ID_product`=4)";
                    $stm2=$conn->prepare($queryNumbers);
                    $stm2->execute();
                    $stm2->store_result();
                    $stm2->bind_result($brokers,$clients,$sellers,$totPayments,$totAdvPayed,$totSubs);
                    $stm2->fetch();
                    // broker
                    $brokerReport[]=array("totalBroker"=>$brokers);
                    // client
                    $clientReport []=array("totalClient"=>$clients);
                    $sellerReport []=array("totalSeller"=>$sellers);

                    $summary=array("advReport"=>$advReport,"brokerReport"=>$brokerReport,
                                   "clientReport"=>$clientReport,
                                   "sellerReport"=>$sellerReport,"totP"=>$totPayments,"totAdvPayed"=>$totAdvPayed,"totSubs"=>$totSubs);

                    $stm2->close();
                    $response = appendData($summary, '100', FALSE);
                    echo json_encode($response);

                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'tablePaymentsAdmin':
                if($_SESSION['level']==0){
                    $referral=$_POST['ref'];
                    $brokerInfo=getBrokerInfo($referral,$conn);
                    if($brokerInfo['error']==false) {
                        $brokerID=$brokerInfo['id'];
                        $query = "SELECT `ID_payment`,`ID_product`,`status`,`amount`,`currency`,`thxID`,`date_payment` from `payments` WHERE `ID_broker`=?";
                        if ($stm = $conn->prepare($query)) {
                            $stm->bind_param("i", $brokerID);
                            if ($stm->execute()) {
                                $stm->store_result();
                                $stm->bind_result($ID_payment, $ID_product, $status, $amount, $currency, $thxID, $datePayment);
                                if ($stm->num_rows >= 1) {
                                    switch ($ID_product) {
                                        case '1':
                                            $adv = 1;
                                            break;
                                        case'2':
                                            $adv = 3;
                                            break;
                                        case '3':
                                            $adv = 6;
                                            break;
                                        case'4':
                                            $adv = "SUB";
                                            break;
                                    }
                                    while ($stm->fetch()) {
                                        $result[] = array("ID" => $thxID, "adv" => $ID_product, "status" => $status, "amount" => $amount . " " . $currency, "date" => $datePayment);
                                    }
                                    $response = appendData($result, '100', FALSE);
                                    echo json_encode($response);
                                } else {
                                    $response = appendData("paym", '210', TRUE);
                                    echo json_encode($response);
                                }
                            } else {
                                $response = appendData($data, '413', TRUE);
                                echo json_encode($response);
                            }
                        } else {
                            $response = appendData($data, '411', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else {
                        $response = appendData($data, $brokerInfo['code'], TRUE);
                        echo json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'getBalances':
                if($_SESSION['level']==0) {
                    $values=array();
                    $labels=array();
                    $start=$_POST['first']. " 00:00:00";
                    $end=$_POST['last']. " 00:00:00";
                    $s=substr($start,0,10);
                    $e=substr($end,0,10);
                    if(empty($_POST['first']) && empty($_POST['last']) ){
                        $query="SELECT `amount`,`date_payment` FROM `payments` WHERE `status`='COMPLETED'";
                        IF($stm=$conn->prepare($query)){
                            if($stm->execute()){
                                $stm->bind_result($amount,$datePayment);
                                $stm->store_result();
                                if($stm->num_rows >0) {
                                    while ($stm->fetch()) {
                                        $day=substr($datePayment,0,10);
                                        $labels[]=substr($datePayment,0,10);
                                        $values[]=$amount;
                                        $balance[]=array("day"=>$day,"amount"=>$amount);
                                    }
                                    $data=array("labels"=>$labels,"values"=>$values,"balance"=>$balance);
                                    $response = appendData($data, '100', FALSE);
                                    echo json_encode($response);
                                }
                                else{
                                    $values=array(0);
                                    $labels=array($s,$e);
                                    $data=array("labels"=>$labels,"values"=>0);
                                    $response = appendData($data, '210', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else{
                                $response = appendData("all", '413', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else{
                            $response = appendData("all", '411', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else{
                        $query="SELECT `amount`,`date_payment` FROM `payments` WHERE `status`='COMPLETED' 
                                AND (`date_payment` BETWEEN ? AND ?) ORDER BY `date_payment` ASC";
                        if($stm=$conn->prepare($query)){
                            $stm->bind_param("ss",$start,$end);
                            if($stm->execute()){
                                $stm->store_result();
                                $stm->bind_result($amount,$datePayment);
                                if($stm->num_rows >0) {
                                    while ($stm->fetch()) {
                                        $day=substr($datePayment,0,10);

                                        $labels[]=substr($datePayment,0,10);
                                        $values[]=$amount;
                                        $balance[]=array("day"=>$day,"amount"=>$amount);
                                    }
                                    $amount = array();

                                    foreach ($balance as $singleBalance){
                                        $index=day_balance_exists($singleBalance['day'],$amount);
                                        if($index<0){
                                            $amount[]=$singleBalance;
                                        }
                                        else{
                                            $amount[$index]['amount']+=$singleBalance['amount'];
                                        }
                                    }


                                    $day=substr($datePayment,0,10);
                                    $data=array("labels"=>$labels,"values"=>$values,"balance"=>$balance);

                                    $response = appendData($data, '100', FALSE);
                                    echo json_encode($response);
                                }
                                else{
                                    $values=array(0);
                                    $labels=array($s,$e);
                                    $data=array("labels"=>$labels,"values"=>$values);
                                    $response = appendData($data, '210', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else{
                                $response = appendData("range", '413', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else{
                            $response = appendData($conn->error, '411', TRUE);
                            echo json_encode($response);
                        }
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
                default:
                sleep(1);
                $response = appendData("Wrong Command", '408',TRUE);
                echo json_encode($response);
                break;
        }
    }
    else {
        $response = appendData($data, '409', TRUE);
        echo json_encode($response);
    }
}
else{echo "dio";}


function appendData($data,$resultCode='100',$error)
{
    $resultCodeToText = array
    (
        '100' => 'OK',
        '101' => 'No CSRFName found',
        '102' => 'Invalid CSRF token.',
        '103' => 'Too many Retry account blocked for 5 minutes',
        '104' => 'Wrong Password',
        '105' => 'Qr image Error',
        '106' => 'Qr image Ok',
        '107' => 'Insert Code',
        '108' => 'Error Server Connection aborted',
        '109' => 'Cannot Found Database',
        '110' => 'No Results',
        '111' => 'Not logged',
        '112' => 'Unauthorised',
        '113' => 'Already Logged',
        '201' => 'Authentication Error',
        '202' => 'Bad Authentication value',
        '203' => 'Bad Authentication parameter',
        '204' => 'Wrong parameter',
        '205' => 'Email Already Exists',
        '206' => 'Token Expired',
        '207' => 'Wrong Token',
        '210' => 'No Results.',
        '401' => 'Bad request',
        '402' => 'Incorrect Parameter Value',
        '403' => 'User Not Allowed',
        '408' => 'Wrong Command',
        '409' => 'Missing Command',
        '410' => 'Required parameter missing',
        '411' => 'Query Error.',
        '412' => 'DB error. Try again later.',
        '413' => 'Execute Query Error',
        '414' => 'Captcha_Error',
        '415' => 'Captcha_Wrong',
        '501' => 'Fill the form correctly',
        '502' => 'Email not exists',
        '800' => 'Invalid Type Docs',
        '801' => 'Error Uploading File',
        '802' => 'Invalid file Size or Type',
        '803' => 'Image Uploaded Successfully!',
        '804' => 'File already exists',
        '805' => 'File Error',
        '806' => 'Max 3 upload'
    );
    $response['resultCode'] = $resultCode;
    $response['errorText'] = $resultCodeToText[$resultCode];
    $response['error'] = $error;
    $response['result'] = $data;
    return $response;
}

