<?php
session_start();
header("Access-Control-Allow-Origin: *");
header('Access-Control-Allow-Credentials: true');
header("Access-Control-Allow-Methods: *");
header("Access-Control-Allow-Headers: content-type,X-Custom-Information, authorization");

include "../inc/db.inc.php";
include "../inc/function.inc.php";

$level=$_SESSION['level'];
if (0 === strpos($_SERVER['CONTENT_TYPE'], 'application/json')) {
    $_POST = json_decode(file_get_contents('php://input'), true);
}


$data=null;
if (!empty($_POST)) {
    $command = $_POST['command'];
    if (isset($_POST['command'])) {
        switch ($command) {
            case 'login':
                if (!isset($_SESSION['user']))
                {
                    if (!empty($_POST['username'] AND $_POST['password'])) {
                        $c=csrfguard_start();
                        if ($c!== "No CSRFName found" && $c!== "Invalid CSRF token.") {
                            $username = stripslashes(strtolower($_POST['username']));
                            $password = stripslashes($_POST['password']);
                            $passCrypted = encryptPassword($password, $username);
                            $issetUsername=isset_username($conn, $username);
                            if ($issetUsername['error']===false) {
                                if($issetUsername['Email_validated']==1) {
                                    $query = "SELECT `ID_broker`,`pwd`,`email`,`adv_free`,`adv_payed`,`adv_used`,`referral`,`profile_img`,`date_pwd_change` FROM `broker` WHERE `pwd`=? AND `email`=? LIMIT 1";
                                    if ($login = $conn->prepare($query)) {
                                        $login->bind_param("ss", $passCrypted,$username);
                                        if ($login->execute()) {
                                            $login->store_result();
                                            $login->bind_result($ID, $db_password, $username, $advFree, $advPayed, $advUsed, $referral, $profileImg,$datePwdchange);
                                            $login->fetch();
                                            if ($login->num_rows == 1) {
                                                if ($passCrypted === $db_password) {
                                                    $today = date('Y-m-d', time());
                                                    $t_login = createToken($ID, $username, $today);
                                                    $_SESSION['user'] = $username;
                                                    $_SESSION['level'] = 1;
                                                    $_SESSION['referral'] = $referral;
                                                    $_SESSION['username'] = $username;

                                                    $_SESSION['t_login'] = $t_login;
                                                    $_SESSION['date_pwd_edit']=$datePwdchange;
                                                    /*$_SESSION['AdvSub'] = $advSub;
                                                    if ($_SESSION['AdvSub'] == 1) {
                                                        $diff=dateDiffInDays($today,$date_subscription);
                                                        $_SESSION['today']=$today;

                                                        $_SESSION['AdvDateSubscription']=$date_subscription;
                                                        $_SESSION['subExpire']=$date_subscription_expire;
                                                        //$_SESSION['subExpire']=date('Y-m-d',strtotime($_SESSION['AdvDateSubscription']."+30days"));
                                                    } else {
                                                        $_SESSION['AdvPublicationRemaining'] = $advPayed + $advFree;
                                                    }*/
                                                    $_SESSION['advUsed']=$advUsed+0;
                                                    $_SESSION['AdvPublicationRemaining'] = $advPayed + $advFree-$advUsed;
                                                    $_SESSION['advFree'] = $advFree;
                                                    $_SESSION['AdvPayed'] = $advPayed;
                                                    $_SESSION['started'] = $_SERVER['REQUEST_TIME'];
                                                    $_SESSION['profileImg'] = $profileImg;
                                                    $_SESSION['ID'] = $ID;
                                                    $updateLogin = updateLogin($conn, $t_login, $ID, $username, 1);

                                                    $response = appendData($data, '100', FALSE);
                                                    echo $json = json_encode($response);
                                                } else {
                                                    sleep(1);
                                                    $response = appendData($data, '201', TRUE);
                                                    echo $json = json_encode($response);
                                                }
                                            } else {
                                                sleep(1);
                                                $response = appendData($data, '104', TRUE);
                                                echo $json = json_encode($response);
                                            }
                                        }
                                        else {
                                            sleep(1);
                                            $response = appendData("username", '413', TRUE);
                                            echo $json = json_encode($response);
                                        }
                                    } else {
                                        sleep(1);
                                        $response = appendData($conn->error, '411', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                }
                                else{
                                    sleep(1);
                                    $response = appendData("username", '114', TRUE);
                                    echo $json = json_encode($response);
                                }
                            } else {
                                sleep(1);
                                $response = appendData("username", '104', TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                        else
                        {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else{
                        $response = appendData($_POST, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '113', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'logout':
                unsetToken($conn,1,$_SESSION['t_login']);
                session_destroy();
                exit();
                break;
            case 'getDashboard':
                if($_SESSION['level']==1){
                    $brokerID=$_SESSION['ID'];
                    // adv
                    $queryAdv="SELECT count(nullif(`published` = false, true)) as `pub`,
                                      count(nullif(`published` = true, true)) as `notPub`, 
                                      count(nullif(`completed` = false, true )) as `completed`,
                                      count(nullif(`rejected` = false, true )) as `rejected`,
                                      count(nullif(`pending` = false, true )) as `pending`,                                     
                                      count(`ID_adv`) as totalRows
                               FROM `adv` WHERE `ID_broker`='$brokerID'";
                    $stm=$conn->prepare($queryAdv);
                    $stm->execute();
                    $stm->store_result();
                    $stm->bind_result($pub,$notPub,$completed,$rejected,$pending,$totalRows);
                    $stm->fetch();
                    $draft=$totalRows-$completed-$pub-$rejected-$pending;
                    $_SESSION['alert_pending']=$pending+0;
                    $_SESSION['alert_rejected']=$rejected+0;
                    $advReport[]=array("pub"=>$pub,"draft"=>$draft,"completed"=>$completed,"rejected"=>$rejected,"pending"=>$pending,
                        "totalAdv"=>$totalRows);

                    // broker
                    $brokerReport[]=array("totalBroker"=>0);
                    // client
                    $clientReport []=array("totalClient"=>0);
                    $summary=array("advReport"=>$advReport,"brokerReport"=>$brokerReport,"clientReport"=>$clientReport);
                    $response = appendData($summary, '100', FALSE);
                    echo json_encode($response);

                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'createBroker':
                if($_SESSION['level'] ==0){
                    if (!empty($_POST['details'])) {
                        $c=csrfguard_start();
                        if ($c!== "No CSRFName found" && $c!== "Invalid CSRF token.") {
                            $arrayDetails = json_decode($_POST['details'], true);
                            $email=$arrayDetails['brokerEmail'];
                            if(!issetEmail($email,$conn,"broker"))
                            {
                                $from=$_POST['btnId'];
                                switch ($from){
                                    case '1':
                                        $createFrom="broker";
                                        break;
                                    case '2':
                                        $createFrom="adv";
                                        break;
                                }
                                $firstName=sanitizeName($arrayDetails['brokerFirstName']);
                                $lastName=sanitizeName($arrayDetails['brokerLastName']);
                                $employment=intval($arrayDetails['brokerEmployment']);
                                $company=sanitizeName($arrayDetails['brokerCompany']);
                                $subscription=$arrayDetails['brokerSubscription'];
                                $description=htmlentities($arrayDetails['brokerDescription']);
                                $vat=htmlentities($arrayDetails['brokerVat']);
                                $vat=substr($vat,0,20);
                                $referral=getReferral($email);
                                $today = date('Y-m-d H:i:s', time());
                                $details=json_encode($arrayDetails,true);
                                $randomPWD=randomPwd();
                                $encryptRandomPWD=encryptPassword($randomPWD,$email);
                                if($stm=$conn->prepare("INSERT INTO `broker` (`email`,`pwd`,`info_broker`,`referral`,`last_modify`,`date_creation`) VALUES(?,?,?,?,?,?)")) {
                                    $stm->bind_param("ssssss",$email,$encryptRandomPWD,$details,$referral,$today,$today);
                                    if($stm->execute()){
                                        $idBroker= $stm->insert_id;
                                        createSeller($conn,$idBroker,$email,$firstName,$lastName,$today,$referral);
                                        $url="broker.php?c=".$referral;
                                        if ($createFrom == "broker") {
                                            $data=array("from"=>"broker","data"=>$url);
                                        }
                                        else{
                                            $name=sanitizeName($firstName)." - ".sanitizeName($lastName);
                                            $arrayInfo=array("name"=>$name,"email"=>$email,"referral"=>$referral);
                                            $data=array("from"=>"adv","item"=>array("info"=>$arrayInfo,"ref"=>$referral));
                                        }
                                        $response = appendData($data, '100', FALSE);
                                        $stm->close();
                                        echo json_encode($response);
                                    }
                                    else{
                                        $stm->close();

                                        $response = appendData($data, '413', TRUE);
                                        echo json_encode($response);
                                    }
                                }
                                else{
                                    $stm->close();
                                    $response = appendData($data, '411', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else{
                                $response = appendData("Email already Used", '205', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else
                        {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else{
                        $response = appendData($_POST, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'editBroker':
                if($_SESSION['level'] <=1) {
                    if (!empty($_POST['details'])) {
                        $c = csrfguard_start();
                        if ($c !== "No CSRFName found" && $c !== "Invalid CSRF token.") {
                            $arrayDetails = json_decode($_POST['details'], true);
                            if($_SESSION['level']==1){
                                $email=$_SESSION['username'];
                            }
                            else {
                                $email = $arrayDetails['brokerEmail'];
                            }
                            $referral=$arrayDetails['brokerReferral'];
                            if (issetEmail($email, $conn, "broker")) {
                                $firstName=sanitizeName($arrayDetails['brokerFirstName']);
                                $lastName=sanitizeName($arrayDetails['brokerLastName']);
                                $company=sanitizeName($arrayDetails['brokerCompany']);
                                $employment=sanitizeName($arrayDetails['brokerEmployment']);
                                $description=htmlentities($arrayDetails['brokerDescription']);
                                $vat=htmlentities($arrayDetails['brokerVat']);
                                $vat=substr($vat,0,20);
                                $today = date('Y-m-d H:i:s', time());
                                $details=json_encode($arrayDetails,true);
                                //$referral=$_SESSION['temp_ref_broker_info'];
                                $active=$arrayDetails['brokerActivateAccount'];
                                switch ($active){
                                    case '0':
                                        $active=0;
                                        break;
                                    case '1':
                                        $active=1;
                                        break;
                                    default:
                                        $active=0;
                                }

                                $queryUpdate="UPDATE `broker` SET
                                                 `info_broker`=?,`last_modify`=?,`active`=? WHERE `referral`=? AND `email`=?";
                                if($stm=$conn->prepare($queryUpdate)){
                                    $stm->bind_param("ssiss",$details,$today,$active,$referral,$email);
                                    if($stm->execute()){
                                        $response = appendData($arrayDetails, '100', FALSE);
                                        echo json_encode($response);
                                    }
                                    else{
                                        $conn->close();
                                        $response = appendData($data, '413', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                }
                                else{
                                    $conn->close();
                                    $response = appendData($data, '411', TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                        }
                        else {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else {
                        $response = appendData($_POST, '410', TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'getBrokerInfo':
                if(isset($_SESSION['level'])){
                    $referral=null;
                    if($_SESSION['level']==1){
                        $referral=$_SESSION['referral'];
                    }
                    elseif ( $_SESSION['level']==0) {
                        if (!empty($_POST['ref'])) {
                            $referral=$_POST['ref'];
                        }
                        else{
                            $response = appendData($_POST, '410',TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    if($referral!=null) {
                        $queryStm = "SELECT `info_broker`,`email`,`active` FROM `broker` WHERE `referral`=? LIMIT 1";
                        if ($stm = $conn->prepare($queryStm)) {
                            $stm->bind_param('s', $referral);
                            if ($stm->execute()) {
                                $stm->store_result();
                                $stm->bind_result($infoBroker, $email, $active);
                                $stm->fetch();
                                if ($stm->num_rows === 1) {
                                    $info = json_decode($infoBroker, true);
                                    $info['brokerEmail'] = $email;
                                    $info['brokerActivateAccount'] = $active;
                                    $info['brokerReferral'] = $referral;
                                    $response = appendData($info, '100', FALSE);
                                    echo json_encode($response);
                                } else {
                                    $response = appendData($data, '210', TRUE);
                                    echo json_encode($response);
                                }
                            } else {
                                $response = appendData($data, '413', TRUE);
                                echo json_encode($response);
                            }
                        } else {
                            $response = appendData($data, '411', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'getBrokerCharts':
                if($_SESSION['level'] <=1){
                    $referral=null;
                    if($_SESSION['level']==1){
                        $referral=$_SESSION['referral'];
                    }
                    elseif ( $_SESSION['level']==0){
                        if (!empty($_POST['ref'])) {
                            $referral=$_POST['ref'];
                        }
                        else{
                            $response = appendData($_POST, '410',TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    if($referral!=null) {
                        $table = array();
                        $chart = array();
                        $totalRows = 0;
                        $draft=0;$pending=0;$rejected=0;$published=0;$completed=0;
                        $queryStm = "SELECT `adv`.`ID_seller`,`adv`.`ID_adv`,`adv`.`advTitle`,`adv`.`advPrice`,`adv`.`advStatus`
                         FROM `adv` INNER join `broker` WHERE `broker`.`ID_broker`=`adv`.`ID_broker` AND `broker`.`referral`=? GROUP BY `ID_adv` ";
                        if ($stm = $conn->prepare($queryStm)) {
                            $stm->bind_param('s', $referral);
                            if ($stm->execute()) {
                                $stm->store_result();
                                $stm->bind_result($ID_seller, $ID_adv, $advTitle, $advPrice,$advStatus);
                                $totalRows = $stm->num_rows;
                                while ($stm->fetch()) {
                                    $url = "a.php?i=" . $ID_adv;
                                    $getLabelStatus=statusAdv($advStatus);
                                    $status=$getLabelStatus['statusLabelDatatable'];
                                    if($advStatus==1){$draft++;}
                                    if($advStatus==2){$pending++;}
                                    if($advStatus==3){$rejected++;}
                                    if($advStatus==4){$published++;}
                                    if($advStatus==5){$completed++;}
                                    $table[] = array("ID_seller" => $ID_seller, "url" => $url, "advTitle" => $advTitle, "advPrice" => $advPrice, "status" => $status);
                                }

                                $chart = array("pub" => $published,"draft"=>$draft,"rejected"=>$rejected,"pending"=>$pending,"completed" => $completed, "totalAdv" => $totalRows);

                                $result = array("table" => $table, "chart" => $chart);
                                $response = appendData($result, '100', FALSE);
                                echo json_encode($response);
                            } else {
                                $response = appendData($data, '413', TRUE);
                                echo json_encode($response);
                            }
                        } else {
                            $response = appendData($conn->error, '411', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }

                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'uploadProfileImage':
                if($_SESSION['level'] <=1){
                    if(!empty($_FILES)) {
                        if (!empty($_POST['ref'])) {
                            $c = csrfguard_start();
                            if ($c !== "No CSRFName found" && $c !== "Invalid CSRF token.") {
                                $ref = $_POST['ref'];
                                //if(($_SESSION['level'] ==1 && $_SESSION['referral'] == $ref) || $_SESSION['level']==0) {
                                if (isset($_SESSION['level'])) {
                                    if (($_SESSION['level'] == 1)) {
                                        $ref = $_SESSION['referral'];
                                    }
                                    if ($ref === $_SESSION['temp_ref_broker_info']) {
                                        $validextensions = array("jpg", "png","jpeg");
                                        $temporary = explode(".", $_FILES["profileBroker"]["name"]);
                                        $file_extension = end($temporary);
                                        $file_extension = strtolower($file_extension);
                                        $_FILES["profileBroker"]["name"] = "profile_" . $ref . "." . $file_extension;
                                        $type = $file_extension;
                                        $path = getPathProfile($ref);
                                        if ((($_FILES["profileBroker"]["type"] == "image/png") || ($_FILES["profileBroker"]["type"] == "image/jpg" || ($_FILES["profileBroker"]["type"] == "image/jpeg")))
                                            && ($_FILES["profileBroker"]["size"] < 2542880)//Approx. 2mb files can be uploaded.
                                            && in_array($file_extension, $validextensions)) {

                                            if ($_FILES["profileBroker"]["error"] > 0) {
                                                //echo "Return Code: " . $_FILES["file"]["error"] . "<br/><br/>";
                                                $response = appendData($data, '805', TRUE);
                                                echo json_encode($response);
                                            } else {
                                                $createpath = "../upload/" . $path . "/";
                                                //mkdir($createpath2, 0776);

                                                if (!is_dir($createpath)) {
                                                    if (mkdir($createpath, 0777)) ;
                                                }

                                                $sourcePath = $_FILES["profileBroker"]['tmp_name'];
                                                $targetPath = "../upload/" . $path . "/" . $_FILES["profileBroker"]['name'];
                                                if (move_uploaded_file($sourcePath, $targetPath)) {
                                                    $finalPath = $path . "/" . $_FILES["profileBroker"]["name"];
                                                    $u = updateProfileBroker($conn, $finalPath, $ref, $_SESSION['level']);
                                                    if (($_SESSION['level'] == 1)) {
                                                        $_SESSION['profileImg'] = $path . "/" . $_FILES["profileBroker"]['name'];
                                                    }
                                                    if ($u['error'] === FALSE) {
                                                        $response = appendData(array("target" => $targetPath, "source" => $_FILES["profileBroker"]['name'], "path" => $path), '803', FALSE);
                                                        echo json_encode($response);
                                                    } else {
                                                        $response = appendData($data, $u['code'], TRUE);
                                                        echo json_encode($response);
                                                    }
                                                } else {
                                                    $response = appendData($data, '801', TRUE);
                                                    echo json_encode($response);
                                                }
                                            }
                                        } else {
                                            $response = appendData($data, '802', TRUE);
                                            echo json_encode($response);
                                        }
                                    } else {
                                        $response = appendData($ref, '204', TRUE);
                                        echo json_encode($response);
                                    }
                                } else {
                                    $response = appendData($ref, '112', TRUE);
                                    echo json_encode($response);
                                }
                            } else {
                                if ($c == "No CSRFName found") {
                                    $response = appendData($data, '101', TRUE);
                                    echo $json = json_encode($response);
                                } elseif ($c !== "Invalid CSRF token") {
                                    $response = appendData($data, '102', TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                        } else {
                            $response = appendData($_POST, '410', TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($_POST, '807', TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'tableBroker':
                if($_SESSION['level'] ==0){
                    if($stm=$conn->prepare("SELECT `referral`,`email`,`info_broker`,`active` FROM `broker` WHERE `ID_broker`!=1")){
                        if($stm->execute()){
                            $stm->store_result();
                            $stm->bind_result($referral,$email,$infoBroker,$active);
                            if($stm->num_rows >=1) {
                                while ($stm->fetch()) {
                                    $details=json_decode($infoBroker,true);

                                    switch ($active){
                                        case'1':
                                            $active="<span class='text-success' data-translate='_enabled'>Enabled</span>";
                                            break;
                                        case'0':
                                            $active="<span class='text-danger' data-translate='_disabled'>Disabled</span>";
                                            break;
                                    }
                                    $url="broker.php?c=".$referral;
                                    $result[]=array("url"=>$url,"email"=>$email,"firstName"=>$details['brokerFirstName'],
                                        "lastName"=>$details['brokerLastName'],
                                        "active"=>$active);
                                }
                                $response = appendData($result, '100', FALSE);
                                echo json_encode($response);
                            }
                            else{
                                $response = appendData($data, '210', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else{
                            $response = appendData($data, '413', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '411', TRUE);
                        echo json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'delImgBroker':
                if($_SESSION['level'] <=1) {
                    if (!empty($_POST['ref'])) {
                        $c = csrfguard_start();
                        if ($c !== "No CSRFName found" && $c !== "Invalid CSRF token.") {
                            $ref = $_POST['ref'];
                            if ($ref === $_SESSION['temp_ref_broker_info']) {
                                if(($_SESSION['level'] ==1 && $_SESSION['referral'] == $ref) || $_SESSION['level']==0) {
                                    if ($stm = $conn->prepare("SELECT `profile_img` FROM `broker` WHERE `referral`='$ref'")) {
                                        if ($stm->execute()) {
                                            $stm->store_result();
                                            $stm->bind_result($urlImage);
                                            $stm->fetch();
                                            if ($stm->num_rows == 1) {
                                                $dir = "../upload/" . $urlImage;
                                                $_SESSION['profileImg']=null;
                                                if (unlink($dir)) {
                                                    $del = $conn->prepare("UPDATE `broker` SET `profile_img`=null  WHERE `referral`='$ref'");
                                                    if ($del->execute()) {
                                                        $response = appendData($data, '100', FALSE);
                                                        echo json_encode($response);
                                                    } else {
                                                        $response = appendData($data, '210', TRUE);
                                                        echo json_encode($response);
                                                    }
                                                }
                                            } else {
                                                $response = appendData($data, '210', TRUE);
                                                echo json_encode($response);
                                            }
                                        } else {
                                            $response = appendData($ref, '413', TRUE);
                                            echo json_encode($response);
                                        }
                                    } else {
                                        $response = appendData($data, '411', TRUE);
                                        echo json_encode($response);
                                    }
                                }
                                else{
                                    $response = appendData($ref, '112', TRUE);
                                    echo json_encode($response);
                                }

                            }
                            else{
                                $response = appendData($ref, '204', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else
                        {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'searchCategories':
                if($_SESSION['level'] <=1){
                    if (isset($_POST['group'])) {
                        if(isset($_SESSION['categories'])) {
                            $group = $_POST['group'];
                            $categories = $_SESSION['categories'];
                            switch ($group) {
                                case "all":
                                    foreach ($categories as $singleCategoryID => $value) {
                                        $result[$singleCategoryID] =$value['category_group_name'];
                                    }
                                    break;
                                default:

                                    $singleCategory=$categories[$group];
                                    $result=$singleCategory['category_type'];
                                    break;
                            }
                            echo json_encode($result);
                        }
                        else{
                            $response = appendData($data, '210', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else {
                        $response = appendData($data, '410', TRUE);
                        echo json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'autoCompleteSearchBroker':
                if ($_SESSION['level']==0) {
                    if($_POST['searchBroker']){

                        $search=$_POST['searchBroker'];
                        $query="SELECT `referral`,`info_broker`,`email` FROM `broker` WHERE `email` LIKE '%$search%' OR `info_broker` LIKE '%$search%'";
                        if($stm=$conn->prepare($query)){
                            if($stm->execute()) {
                                $stm->store_result();
                                $stm->bind_result($referral, $infoBroker,$email);
                                if ($stm->num_rows >=1){
                                    while ($stm->fetch()){
                                        $brokerInfo=json_decode($infoBroker,true);
                                        $name=sanitizeName($brokerInfo['brokerFirstName']);
                                        $surname=sanitizeName($brokerInfo['brokerLastName']);
                                        $string="<b>".$name." , ".$surname."   <span>&nbsp;</span>   ".$email. "</b>" ;
                                        $name=$name." - ".$surname;
                                        $broker=array("name"=>$name,"email"=>$email,"referral"=>$referral);
                                        $data[]=array("value"=>$email,"ref"=>$referral,"label"=>$string,"info"=>$broker);
                                    }
                                    $response = appendData($data, '100', TRUE);
                                    echo json_encode($response);
                                }
                                else{
                                    $response = appendData($data, '210', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else{
                                $response = appendData($data, '411', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else{
                            $response = appendData($data, '413', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '410', TRUE);
                        echo json_encode($response);
                    }
                }
                else
                {
                    $response = appendData($data, '111', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'createAdv':
                if($_SESSION['level'] <=1) {
                    if (!empty($_POST['details']) & !empty($_POST['seller'])) {
                        $sellerChoosen=$_POST['seller'];
                        $brokerChoosen=$_POST['broker'];
                        $arrayDetails = json_decode($_POST['details'], true);
                        $sellerEmail=$_POST['emailSeller'];
                        $brokerEmail=$_POST['emailBroker'];
                        if($_SESSION['level']==0 && $brokerChoosen ==2 && empty($brokerEmail)){
                            $response = appendData("broker", '402', TRUE);
                            echo $json = json_encode($response);
                        }
                        else {
                            if($sellerChoosen==2 && empty($sellerEmail)){
                                $response = appendData("seller", '402', TRUE);
                                echo $json = json_encode($response);
                            }
                            else {
                                $c = csrfguard_start();
                                if ($c !== "No CSRFName found" && $c !== "Invalid CSRF token.") {

                                    if ($_SESSION['level'] === 0) {
                                        switch ($brokerChoosen) {
                                            case '1':
                                                $idBroker['error']=FALSE;
                                                $idBroker=0;
                                                break;
                                            case '2':
                                                $idBroker=issetEmail($brokerEmail, $conn, "broker");
                                                if ($idBroker===false) {
                                                   $brokerEmail=null;
                                                    $idBroker['error']=TRUE;
                                                }

                                                $brokerReferral = getReferral($brokerEmail);
                                                break;
                                            default:
                                                $brokerEmail=null;
                                                $idBroker=null;
                                                break;
                                        }
                                        switch ($sellerChoosen) {
                                            case '1':
                                                $selfSeller=1;
                                                $idSeller=0;
                                                break;
                                            case '2':
                                                $selfSeller=0;
                                                $getSellerID = getSellerID($sellerEmail,$conn);
                                                $idSeller=$getSellerID['result'];
                                                break;
                                        }

                                    } else {
                                        $brokerEmail=$_SESSION['username'];
                                        $brokerReferral = getReferral($brokerEmail);
                                        $idBroker=$_SESSION['ID'];
                                        switch ($sellerChoosen) {
                                            case '1':
                                                $selfSeller=1;
                                                $getSellerID = getSellerID($brokerEmail,$conn);
                                                break;
                                            case '2':
                                                $selfSeller=0;
                                                $getSellerID = getSellerID($sellerEmail,$conn);
                                                break;
                                        }
                                        $idSeller=$getSellerID['result'];
                                    }

                                    if($getSellerID['error'] == TRUE){
                                        $response = appendData("seller", '402', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                    else{
                                        if($idBroker['error']==TRUE){
                                            $response = appendData("broker", '402', TRUE);
                                            echo $json = json_encode($response);
                                        }
                                        else{

                                            $today = date('Y-m-d H:i:s', time());
                                            $advTitle = sanitizeName($arrayDetails['advTitle']);
                                            $advPrice=$arrayDetails['advPrice'];
                                            if(empty($arrayDetails['advPrice'])){
                                                $advPrice="0,00";
                                            }
                                            $advDescription = htmlentities($arrayDetails['advDescription']);
                                            $categoryType = $arrayDetails['categoryType'];
                                            $categoryGroup = $arrayDetails['categoryGroup'];
                                            $capCode=$arrayDetails['advCity'];
                                            $district=$arrayDetails['advDistrict'];
                                            $arrayAdv=array("advDescription"=>$advDescription,
                                                "advTitle"=>$advTitle,"advPrice"=>$advPrice,
                                                "categoryGroup"=>$categoryGroup,"categoryType"=>$categoryType,"district"=>intval($district),"cap"=>$capCode
                                            );
                                            $details = json_encode($arrayAdv, true);
                                            $query="INSERT INTO `adv` (`ID_broker`,`ID_seller`,`self_seller`,`info_adv`,`advTitle`,`date_creation`,`advPrice`) VALUES (?,?,?,?,?,?,?)";
                                            if($stm=$conn->prepare($query)) {
                                                $stm->bind_param("iiissss",$idBroker,$idSeller,$selfSeller,$details,$advTitle,$today,$advPrice);
                                                if($stm->execute()){
                                                    $idAdv= $stm->insert_id;
                                                    $url="a.php?i=".$idAdv;
                                                    $response = appendData($url, '100', FALSE);
                                                    echo json_encode($response);
                                                }
                                                else {
                                                    $response = appendData($data, '413', TRUE);
                                                    echo json_encode($response);
                                                }
                                            }
                                            else{
                                                $response = appendData($conn->error, '411', TRUE);
                                                echo json_encode($response);
                                            }
                                        }
                                    }

                                } else {
                                    if ($c == "No CSRFName found") {
                                        $response = appendData($data, '101', TRUE);
                                        echo $json = json_encode($response);
                                    } elseif ($c !== "Invalid CSRF token") {
                                        $response = appendData($data, '102', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                }
                            }
                        }
                    }
                    else{
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'editAdv':
                if($_SESSION['level'] <=1) {
                    if (!empty($_POST['details']) && !empty($_POST['adv'])) {
                        $c = csrfguard_start();
                        if ($c !== "No CSRFName found" && $c !== "Invalid CSRF token.") {
                            $arrayDetails = json_decode($_POST['details'], true);
                            $email = $arrayDetails['brokerEmail'];
                            $referral=$_SESSION['temp_ref_adv_info'];
                            $refAdv=$_POST['adv'];
                            $getStatusAdvUser=getStatusAdv( $referral,$conn);
                            $statusAdvUser=$getStatusAdvUser['result'];

                            if($_SESSION['level'] >0 && $statusAdvUser == '5' ){
                                $response = appendData($data, '214', TRUE);
                                echo $json = json_encode($response);
                            }
                            else {
                                if ($referral == $refAdv) {
                                    $showPrice = $arrayDetails['advShowPrice'];
                                    $showSeller = $arrayDetails['advShowSeller'];
                                    $showBroker = $arrayDetails['advShowBroker'];
                                    $sellerEmail = $arrayDetails['sellerEmail'];
                                    $brokerEmail = $arrayDetails['brokerEmail'];
                                    $sellerChoosen = $_POST['seller'];
                                    $brokerChoosen = $_POST['broker'];
                                    switch ($showPrice) {
                                        case'1':
                                            $showPrice = 1;
                                            break;
                                        case'0':
                                            $showPrice = 0;
                                            break;
                                        default:
                                            $showPrice = 0;
                                    }
                                    switch ($showSeller) {
                                        case'1':
                                            $showSeller = 1;
                                            break;
                                        case'0':
                                            $showSeller = 0;
                                            break;
                                        default:
                                            $showSeller = 0;
                                    }
                                    switch ($showBroker) {
                                        case'1':
                                            $showBroker = 1;
                                            break;
                                        case'0':
                                            $showBroker = 0;
                                            break;
                                        default:
                                            $showBroker = 0;
                                    }
                                    if ($_SESSION['level'] == 0) {

                                        switch ($statusAdvUser) {
                                            case '1':
                                                $pending = 0;
                                                $rejected = 0;
                                                $published = 0;
                                                $completed = 0;
                                                break;
                                            case '2':
                                                $pending = 1;
                                                $rejected = 0;
                                                $published = 0;
                                                $completed = 0;
                                                break;
                                            case'3':
                                                $pending = 0;
                                                $rejected = 1;
                                                $published = 0;
                                                $completed = 0;
                                                break;
                                            case'4':
                                                $pending=0;
                                                $rejected=0;
                                                $published=1;
                                                $completed=0;
                                                break;
                                            case'5':
                                                $pending = 0;
                                                $rejected = 0;
                                                $published = 0;
                                                $completed = 1;
                                                break;
                                        }
                                        switch ($brokerChoosen) {
                                            case '1':
                                                $getBrokerId['error'] = FALSE;
                                                $idBroker = 0;
                                                break;
                                            case '2':
                                                $getBrokerId =getBrokerID($email,$conn);
                                                if ($getBrokerId['error'] === true) {
                                                    $brokerEmail = null;
                                                }
                                                else{
                                                    $idBroker=$getBrokerId['result'];
                                                }

                                                $brokerReferral = getReferral($brokerEmail);
                                                break;
                                            default:
                                                $brokerEmail = null;
                                                $idBroker = null;
                                                break;
                                        }
                                        switch ($sellerChoosen) {
                                            case '1':
                                                $selfSeller = 1;
                                                $idSeller = 0;
                                                break;
                                            case '2':
                                                $selfSeller = 0;
                                                $getSellerID = getSellerID($sellerEmail, $conn);
                                                $idSeller = $getSellerID['result'];
                                                break;
                                        }
                                    }
                                    else {
                                        $pending = 1;
                                        $rejected = 0;
                                        $published = 0;
                                        $completed = 0;
                                        $brokerEmail = $_SESSION['username'];
                                        $brokerReferral = getReferral($brokerEmail);
                                        $idBroker = $_SESSION['ID'];
                                        switch ($sellerChoosen) {
                                            case '1':
                                                $selfSeller = 1;
                                                $getSellerID = getSellerID($brokerEmail, $conn);
                                                break;
                                            case '2':
                                                $selfSeller = 0;
                                                $getSellerID = getSellerID($sellerEmail, $conn);
                                                break;
                                        }
                                        $idSeller = $getSellerID['result'];
                                    }

                                    if ($getSellerID['error'] == TRUE) {
                                        $response = appendData("seller", '402', TRUE);
                                        echo $json = json_encode($response);
                                    } else {
                                        if ($getBrokerId['error'] == TRUE) {
                                            $response = appendData($arrayDetails, '402', TRUE);
                                            echo $json = json_encode($response);
                                        } else {
                                            $now = date('Y-m-d H:i:s', time());

                                            $advTitle = $arrayDetails['advTitle'];
                                            $advTitle = sanitizeName($arrayDetails['advTitle']);
                                            $advDescription = htmlentities($arrayDetails['advDescription']);
                                            $categoryType = $arrayDetails['categoryType'];
                                            $categoryGroup = $arrayDetails['categoryGroup'];
                                            $district = $arrayDetails['advDistrict'];
                                            $cap = $arrayDetails['advCity'];
                                            $advPrice = $arrayDetails['advPrice'];
                                            if (empty($arrayDetails['advPrice'])) {
                                                $advPrice = "0,00";
                                            }


                                            if ($completed == 1) {
                                                $dateCompleted = $now;
                                            } else {
                                                $dateCompleted = null;
                                            }
                                            if ($published == 1) {
                                                $datePublished = $now;
                                            } else {
                                                $datePublished = null;
                                            }
                                            $details = json_encode($arrayDetails, true);

                                            $infoAdv = json_encode(array("advDescription" => $advDescription, "advTitle" => $advTitle, "advPrice" => $advPrice,
                                                "categoryGroup" => $categoryGroup, "categoryType" => $categoryType, "district" => $district,
                                                "cap" => $cap), true);

                                            $queryUpdate = "UPDATE `adv` SET
                                                 `ID_broker`=?,`ID_seller`=?,`self_seller`=?,`info_adv`=?,`advTitle`=?,`advPrice`=?,
                                                 `showPrice`=?,`showSeller`=?,`showBroker`=?,`pending`=?,`rejected`=?,`published`=?,`completed`=?
                                
                                                  WHERE `ID_adv`=?";

                                            if ($stm = $conn->prepare($queryUpdate)) {
                                                $stm->bind_param("iiisssiiiiiiii", $idBroker, $idSeller, $selfSeller, $infoAdv, $advTitle, $advPrice, $showPrice,
                                                    $showSeller, $showBroker, $pending, $rejected, $published, $completed, $referral);
                                                if ($stm->execute()) {
                                                    $response = appendData($arrayDetails, '100', FALSE);
                                                    echo json_encode($response);
                                                } else {
                                                    $response = appendData($conn->error, '413', TRUE);
                                                    $conn->close();
                                                    echo $json = json_encode($response);
                                                }
                                            } else {

                                                $response = appendData($conn->error, '411', TRUE);
                                                $conn->close();
                                                echo $json = json_encode($response);
                                            }
                                        }
                                    }
                                } else {
                                    $response = appendData($data, '402', TRUE);
                                    echo $json = json_encode($response);
                                }
                            }

                        }
                        else {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else {
                        $response = appendData($_POST, '410', TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }

                break;
            case 'setDraft':
                if ($_SESSION['level']>=0) {
                    if (isset($_POST['i'])){
                        $advID=intval($_POST['i']);
                        if($_SESSION['level']===0){
                            $checkOwner=checkOwnerAdvAdmin($advID,$conn);
                            $brokerID=$checkOwner['result']['ID_broker'];
                        }
                        else{
                            $brokerID=$_SESSION['ID'];
                            $checkOwner=checkOwnerAdv($advID,$brokerID,$conn);
                        }
                        if($checkOwner['error']===FALSE){
                            $advIsCompleted=$checkOwner['result']['completed'];
                            if($advIsCompleted==1 && $_SESSION['level']>0){
                                $response = appendData($data, '401', TRUE);
                                echo $json = json_encode($response);
                            }
                            else {
                                $query = "UPDATE `adv` SET `completed`=0,`published`=0,`pending`=0,`rejected`=0,`advStatus`=1 WHERE `ID_adv`=? AND `ID_broker`=? ";
                                if ($stm = $conn->prepare($query)) {
                                    $stm->bind_param("ii", $advID, $brokerID);
                                    if ($stm->execute()) {
                                        $response = appendData($data, '100', FALSE);
                                        echo $json = json_encode($response);
                                    } else {
                                        $response = appendData("update",'411', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                } else {
                                    $response = appendData($data, '413', TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                        }
                        else{
                            $response = appendData("checkOW", $checkOwner['code'],TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'setPending':
                if ($_SESSION['level']>=0) {
                    if (isset($_POST['i'])){
                        $advID=intval($_POST['i']);
                        if($_SESSION['level']===0){
                            $checkOwner=checkOwnerAdvAdmin($advID,$conn);
                            $brokerID=$checkOwner['result']['ID_broker'];
                        }
                        else{
                            $brokerID=$_SESSION['ID'];
                            $checkOwner=checkOwnerAdv($advID,$brokerID,$conn);
                        }
                        if($checkOwner['error']===FALSE){
                            $advIsPublished=$checkOwner['result']['published'];
                            $advIsCompleted=$checkOwner['result']['completed'];
                            $advIsPending=$checkOwner['result']['pending'];
                            $advSub = $checkOwner['result']['advSub'];
                            $dayRemaining = $checkOwner['result']['day_remaining'];
                            if($advIsPending==1 ){
                                $response = appendData($data, '401', TRUE);
                                echo $json = json_encode($response);
                            }
                            else {
                                $advTokenUsed=$checkOwner['result']['adv_token_used'];
                                $counterFree = $checkOwner['result']['counterFree'];
                                $counterPayed = $checkOwner['result']['counterPayed'];
                                $counter['error']=true;
                                // Adv token used ==1 --> adv già pagato
                                if($advTokenUsed !=1) {
                                    if ($advSub == 0) {
                                        $counterFree = $checkOwner['result']['counterFree'];
                                        $counterPayed = $checkOwner['result']['counterPayed'];
                                        $totCounter = $counterFree + $counterPayed + 0;
                                        if ($totCounter == 0) {
                                            $counter['error'] = true;
                                            $counter['response'] = appendData($data, '211', TRUE);
                                        } else {
                                            if ($counterFree > 0) {
                                                $counterFree = $counterFree - 1;
                                            } else {
                                                $counterPayed = $counterPayed - 1;
                                            }

                                            $counter['error'] = false;
                                        }
                                    } else if ($advSub == 1) {
                                        if ($dayRemaining <= 0) {
                                            $counter['error'] = true;
                                            $counter['response'] = appendData($checkOwner['result']['day_remaining'], '212', TRUE);
                                        } else {
                                            $counter['error'] = false;
                                        }
                                    }
                                }
                                else{
                                    $counter['error']=false;
                                }

                                if ($counter['error']==false){

                                    $query = "UPDATE `adv` SET `pending`=1,`rejected`=0,`completed`=0,`published`=0,`advStatus`=2 WHERE `ID_adv`=? AND `ID_broker`=? ";
                                    if ($stm = $conn->prepare($query)) {
                                        $stm->bind_param("ii", $advID, $brokerID);
                                        if ($stm->execute()) {
                                            $response = appendData($checkOwner, '100', FALSE);
                                            echo $json = json_encode($response);
                                        } else {
                                            $response = appendData($data, '413', TRUE);
                                            echo $json = json_encode($response);
                                        }
                                    } else {
                                        $response = appendData("update ADV", '411', TRUE);
                                        echo $json = json_encode($response);
                                    }

                                }
                                else{
                                    $response = $counter['response'];
                                    echo $json = json_encode($response);
                                }
                            }
                        }
                        else{
                            $response = appendData("checkOW", $checkOwner['code'],TRUE);
                            echo $json = json_encode($response);
                        }

                    }
                    else{
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'setApproved':
                if ($_SESSION['level']===0) {
                    if (isset($_POST['i'])){
                        $advID=intval($_POST['i']);
                        $checkOwner=checkOwnerAdvAdmin($advID,$conn);
                        if($checkOwner['error']===FALSE){
                            $advTokenUsed=$checkOwner['result']['adv_token_used'];
                            $brokerID=$checkOwner['result']['ID_broker'];
                            $advStatus=$checkOwner['result']['advStatus'];
                            $advSub = $checkOwner['result']['advSub'];
                            $dayRemaining = $checkOwner['result']['day_remaining'];
                            if(($advStatus==4)){
                                $response = appendData($data, '401', TRUE);
                                echo $json = json_encode($response);
                            }
                            else {
                                $counter['error'] = true;

                                if( $advTokenUsed!=1) {
                                    if ($advSub == 0) {
                                        $counterFree = $checkOwner['result']['counterFree'];
                                        $counterPayed = $checkOwner['result']['counterPayed'];
                                        $totCounter = $counterFree + $counterPayed + 0;
                                        if ($totCounter == 0) {
                                            $response = appendData($data, '211', TRUE);
                                            echo $json = json_encode($response);
                                        }
                                        else {
                                            if ($counterFree > 0) {
                                                $counterFree = $counterFree - 1;
                                            } else {
                                                $counterPayed = $counterPayed - 1;
                                            }
                                            $counter['error'] = false;
                                        }
                                    } else if ($advSub == 1) {
                                        if ($dayRemaining <= 0) {
                                            $response = appendData($data, '212', TRUE);
                                            echo $json = json_encode($response);
                                        } else {
                                            $counter['error'] = false;
                                        }
                                    }
                                }
                                else{
                                    $counter['error'] = false;
                                }
                                if ($counter['error']==false){
                                    $query = "UPDATE `adv` SET `published`=1,`rejected`=0,`completed`=0,`pending`=0,`adv_token_used`=1,`advStatus`=4 WHERE `ID_adv`=? AND `ID_broker`=? ";
                                    if ($stmUpdate = $conn->prepare($query)) {
                                        $stmUpdate->bind_param("ii", $advID, $brokerID);
                                        if ($stmUpdate->execute()) {
                                            if( $advTokenUsed!=1) {
                                                $update = updateCounter($conn, $counterFree, $counterPayed, $advSub, $brokerID);
                                            }
                                            else{
                                                $update['error'] = FALSE;
                                            }
                                            if ($update['error'] == FALSE) {
                                                $response = appendData(array("q"=>$query,"adv"=>$advID,"brokerID"=>$brokerID), '100', FALSE);
                                                echo $json = json_encode($response);
                                            } else {
                                                $response = appendData("updateC", $update['code'], TRUE);
                                                echo $json = json_encode($response);
                                            }
                                        } else {
                                            $response = appendData($data, '413', TRUE);
                                            echo $json = json_encode($response);
                                        }
                                    } else {
                                        $response = appendData("update ADV", '411', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                }
                                else{
                                    $response = appendData($data, '213',TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                        }
                        else{
                            $response = appendData("checkOW", $checkOwner['code'],TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'setCompleted':
                if ($_SESSION['level']===0) {
                    if (isset($_POST['i'])){
                        $advID=intval($_POST['i']);
                        $checkOwner=checkOwnerAdvAdmin($advID,$conn);
                        if($checkOwner['error']===FALSE){
                            $advTokenUsed=$checkOwner['result']['adv_token_used'];
                            $brokerID=$checkOwner['result']['ID_broker'];
                            $advIsCompleted=$checkOwner['result']['completed'];
                            $advSub = $checkOwner['result']['advSub'];
                            $dayRemaining = $checkOwner['result']['day_remaining'];
                            if($advIsCompleted==1){
                                $response = appendData($data, '401', TRUE);
                                echo $json = json_encode($response);
                            }
                            else {
                                $query = "UPDATE `adv` SET `published`=0,`rejected`=0,`completed`=1,`pending`=0,`advStatus`=5 WHERE `ID_adv`=? AND `ID_broker`=? ";
                                if ($stm = $conn->prepare($query)) {
                                    $stm->bind_param("ii", $advID, $brokerID);
                                    if ($stm->execute()) {
                                        $response = appendData($data, '100', FALSE);
                                        echo $json = json_encode($response);

                                    } else {
                                        $response = appendData($data, '413', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                } else {
                                    $response = appendData("update ADV", '411', TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                        }
                        else{
                            $response = appendData("checkOW", $checkOwner['code'],TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'setRejected':
                if ($_SESSION['level']===0) {
                    if (isset($_POST['i'])){
                        $advID=intval($_POST['i']);
                        $checkOwner=checkOwnerAdvAdmin($advID,$conn);
                        if($checkOwner['error']===FALSE){
                            $advIsRejected=$checkOwner['result']['rejected'];
                            $brokerID=$checkOwner['result']['ID_broker'];
                            if($advIsRejected==1 && $_SESSION['level']>0){
                                $response = appendData($data, '401', TRUE);
                                echo $json = json_encode($response);
                            }
                            else {
                                $query = "UPDATE `adv` SET `published`=0,`rejected`=1,`completed`=0,`pending`=0,`advStatus`=3 WHERE `ID_adv`=? AND `ID_broker`=? ";
                                if ($stm = $conn->prepare($query)) {
                                    $stm->bind_param("ii", $advID, $brokerID);
                                    if ($stm->execute()) {
                                        $response = appendData($data, '100', FALSE);
                                        echo $json = json_encode($response);

                                    } else {
                                        $response = appendData($data, '413', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                } else {
                                    $response = appendData("update ADV", '411', TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                        }
                        else{
                            $response = appendData("checkOW", $checkOwner['code'],TRUE);
                            echo $json = json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'createClient':
                if($_SESSION['level'] ==0){
                    if (!empty($_POST['details'])) {
                        $c=csrfguard_start();
                        if ($c!== "No CSRFName found" && $c!== "Invalid CSRF token.") {
                            $arrayDetails = json_decode($_POST['details'], true);
                            $email=$arrayDetails['clientEmail'];
                            if(!issetEmail($email,$conn,"client"))
                            {
                                $firstName=sanitizeName($arrayDetails['clientFirstName']);
                                $lastName=sanitizeName($arrayDetails['clientLastName']);
                                $name=$firstName." - ".$lastName;
                                $arrayDetails['name']=$name;
                                $description=htmlentities($arrayDetails['clientDescription']);
                                $today = date('Y-m-d H:i:s', time());
                                $details=json_encode($arrayDetails,true);
                                $randomPWD=randomPwd();
                                $referral=getReferral($email);
                                $encryptRandomPWD=encryptPassword($randomPWD,$email);
                                $emailValidateToken=getEmailToken($email,$today);
                                if($stm=$conn->prepare("INSERT INTO `client` (`email`,`pwd`,`email_validate_token`,`info_client`,`referral`,`last_modify`,`date_creation`) VALUES(?,?,?,?,?,?,?)")) {
                                    $stm->bind_param("sssssss",$email,$encryptRandomPWD,$emailValidateToken,$details,$referral,$today,$today);
                                    if($stm->execute()){
                                        $idSeller= $stm->insert_id;
                                        $url="client.php?c=".$referral;
                                        $response = appendData($conn->error, '100', FALSE);
                                        echo json_encode($response);
                                    }
                                    else{
                                        $response = appendData($conn->error, '413', TRUE);
                                        echo json_encode($response);
                                    }
                                }
                                else{
                                    $response = appendData($data, '411', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else{
                                $response = appendData("Email already Used", '205', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else
                        {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else{
                        $response = appendData($_POST, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'editClient':
                if($_SESSION['level'] ==0) {
                    if (!empty($_POST['details']) && !empty($_POST['ref'])) {
                        $c=csrfguard_start();
                        if ($c!== "No CSRFName found" && $c!== "Invalid CSRF token.") {
                            $ID_client=$_POST['ref'];
                            $arrayDetails = json_decode($_POST['details'], true);
                            $clientEmail=$arrayDetails['clientEmail'];
                            $infoClient=getClientInfo($ID_client,$conn);

                            if($infoClient['error'] === false)
                            {
                                $clientFirstName=sanitizeName($arrayDetails['clientFirstName']);
                                $clientLastName=sanitizeName($arrayDetails['clientLastName']);
                                $clientDescription=htmlentities($arrayDetails['clientDescription']);

                                $today = date('Y-m-d H:i:s', time());
                                $infoClient=json_encode(array(
                                    "clientFirstName"=>$clientFirstName,"clientLastName"=>$clientLastName,
                                    "clientDescription"=>$clientDescription,
                                    "clientEmail"=>$clientEmail),true);
                                $query="UPDATE `client` SET `info_client`=?,`last_modify`=? WHERE `ID_client`=? ";
                                if($stm=$conn->prepare($query)){
                                    $stm->bind_param("ssi",$infoClient,$today,$ID_client);
                                    if($stm->execute()){
                                        $response = appendData($infoClient, '100', FALSE);
                                        echo json_encode($response);
                                    }
                                    else{
                                        $conn->close();
                                        $response = appendData($data, '413', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                }
                                else{
                                    $response = appendData($data, '411',TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                            else{
                                $response = appendData("broker", '112', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else
                        {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else{
                        $response = appendData($_POST, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'tableClient':
                if($_SESSION['level'] ==0){
                    if($stm=$conn->prepare("SELECT `ID_client`,`referral`,`email`,`info_client` FROM `client`")){
                        if($stm->execute()){
                            $stm->store_result();
                            $stm->bind_result($ID_client,$referral,$email,$infoClient);
                            if($stm->num_rows >=1) {
                                while ($stm->fetch()) {
                                    $details=json_decode($infoClient,true);
                                    if($_SESSION['level']===0) {
                                        $url = "client.php?c=" . $ID_client;
                                    }
                                    else{
                                        $url = "#";
                                    }
                                    $result[]=array("url"=>$url,"clientEmail"=>$email,"clientFirstName"=>$details['clientFirstName'],
                                        "clientLastName"=>$details['clientLastName']);
                                }
                                $response = appendData($result, '100', FALSE);
                                echo json_encode($response);
                            }
                            else{
                                $response = appendData($data, '210', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else{
                            $response = appendData($data, '413', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '411', TRUE);
                        echo json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'createSeller':
                if($_SESSION['level'] ==0){
                    if (!empty($_POST['details'])) {
                        $c=csrfguard_start();
                        if ($c!== "No CSRFName found" && $c!== "Invalid CSRF token.") {
                            $arrayDetails = json_decode($_POST['details'], true);
                            $email=$arrayDetails['sellerEmail'];
                            if(!issetEmail($email,$conn,"seller"))
                            {
                                $from=$_POST['btnId'];
                                switch ($from){
                                    case '1':
                                        $createFrom="seller";
                                        break;
                                    case '2':
                                        $createFrom="adv";
                                        break;
                                }
                                $firstName=sanitizeName($arrayDetails['sellerFirstName']);
                                $lastName=sanitizeName($arrayDetails['sellerLastName']);
                                $name=$firstName." - ".$lastName;
                                $arrayDetails['name']=$name;
                                $vat=sanitizeName($arrayDetails['sellerVat']);
                                $vat=substr($vat,0,20);
                                $description=htmlentities($arrayDetails['sellerDescription']);
                                $today = date('Y-m-d H:i:s', time());
                                $details=json_encode($arrayDetails,true);
                                $randomPWD=randomPwd();
                                $referral=getReferral($email);
                                $encryptRandomPWD=encryptPassword($randomPWD,$email);
                                if($stm=$conn->prepare("INSERT INTO `seller` (`email`,`pwd`, `info_seller`,`referral`,`last_modify`,`date_creation`) VALUES(?,?,?,?,?,?)")) {
                                    $stm->bind_param("ssssss",$email,$encryptRandomPWD,$details,$referral,$today,$today);
                                    if($stm->execute()){
                                        $idSeller= $stm->insert_id;
                                        $url="seller.php?s=".$referral;
                                        if ($createFrom == "seller") {
                                            $data=array("from"=>"seller","data"=>$url);
                                        }
                                        else{
                                            $data=array("from"=>"adv","item"=>array("info"=>$arrayDetails,"id"=>$idSeller,"value"=>$email));
                                        }
                                        $response = appendData($data, '100', FALSE);
                                        echo json_encode($response);
                                    }
                                    else{
                                        $response = appendData($conn->error, '413', TRUE);
                                        echo json_encode($response);
                                    }
                                }
                                else{
                                    $response = appendData($data, '411', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else{
                                $response = appendData("Email already Used", '205', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else
                        {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else{
                        $response = appendData($_POST, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'editSeller':
                if($_SESSION['level'] ==0) {
                    if (!empty($_POST['details']) && !empty($_POST['ref'])) {
                        $c=csrfguard_start();
                        if ($c!== "No CSRFName found" && $c!== "Invalid CSRF token.") {
                            $from=$_POST['btnId'];
                            switch ($from){
                                case '1':
                                    $createFrom="seller";
                                    break;
                                case '2':
                                    $createFrom="adv";
                                    break;
                            }
                            $ID_seller=$_POST['ref'];
                            $arrayDetails = json_decode($_POST['details'], true);
                            $sellerEmail=$arrayDetails['sellerEmail'];
                            $infoSeller=getSellerInfo($ID_seller,$conn);
                            if($infoSeller['ID_broker'] === null)
                            {
                                $sellerFirstName=sanitizeName($arrayDetails['sellerFirstName']);
                                $sellerLastName=sanitizeName($arrayDetails['sellerLastName']);
                                $sellerDescription=htmlentities($arrayDetails['sellerDescription']);
                                $sellerVat=sanitizeName($arrayDetails['sellerVat']);
                                $sellerVat=substr($sellerVat,0,20);
                                $today = date('Y-m-d H:i:s', time());
                                $infoSeller=json_encode(array(
                                                    "sellerFirstName"=>$sellerFirstName,"sellerLastName"=>$sellerLastName,
                                                    "sellerDescription"=>$sellerDescription,
                                                    "sellerVat"=>$sellerVat,"sellerEmail"=>$sellerEmail),true);
                                $query="UPDATE `seller` SET `info_seller`=?,`last_modify`=? WHERE `ID_seller`=? ";
                                if($stm=$conn->prepare($query)){
                                    $stm->bind_param("ssi",$infoSeller,$today,$ID_seller);
                                    if($stm->execute()){
                                        $response = appendData($infoSeller, '100', FALSE);
                                        echo json_encode($response);
                                    }
                                    else{
                                        $conn->close();
                                        $response = appendData($data, '413', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                }
                                else{
                                    $response = appendData($data, '411',TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                            else{
                                $response = appendData("broker", '112', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else
                        {
                            if($c=="No CSRFName found")
                            {
                                $response = appendData($data, '101',TRUE);
                                echo $json = json_encode($response);
                            }
                            elseif ($c!== "Invalid CSRF token")
                            {
                                $response = appendData($data, '102',TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                    }
                    else{
                        $response = appendData($_POST, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'tableSeller':
                if($_SESSION['level'] <=1){
                    if($stm=$conn->prepare("SELECT `ID_seller`,`referral`,`email`,`info_seller` FROM `seller`")){
                        if($stm->execute()){
                            $stm->store_result();
                            $stm->bind_result($ID_seller,$referral,$email,$infoSeller);
                            if($stm->num_rows >=1) {
                                while ($stm->fetch()) {
                                    $details=json_decode($infoSeller,true);
                                    if($_SESSION['level']===0) {
                                        $url = "seller.php?s=" . $ID_seller;
                                    }
                                    else{
                                        $url = "#";
                                    }
                                    $result[]=array("url"=>$url,"sellerEmail"=>$email,"sellerFirstName"=>$details['sellerFirstName'],
                                        "sellerLastName"=>$details['sellerLastName']);
                                }
                                $response = appendData($result, '100', FALSE);
                                echo json_encode($response);
                            }
                            else{
                                $response = appendData($data, '210', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else{
                            $response = appendData($data, '413', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '411', TRUE);
                        echo json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'autoCompleteSearchSeller':
                if ($_SESSION['level']<=1) {
                    if($_POST['searchSeller']){

                        $search=$_POST['searchSeller'];
                        $query="SELECT `referral`,`info_seller`,`email` FROM `seller` WHERE `email` LIKE '%$search%' OR `info_seller` LIKE '%$search%'";
                        if($stm=$conn->prepare($query)){
                            if($stm->execute()) {
                                $stm->store_result();
                                $stm->bind_result($referral, $infoSeller,$email);
                                if ($stm->num_rows >=1){
                                    while ($stm->fetch()){
                                        $infoSeller=json_decode($infoSeller,true);
                                        $infoSellerName=sanitizeName($infoSeller['sellerFirstName']);
                                        $infoSellerLastName=sanitizeName($infoSeller['sellerLastName']);
                                        $name=$infoSellerName." - ".$infoSellerLastName;
                                        $seller=array("name"=>$name,"email"=>$email,"referral"=>$referral);
                                        $string="<b>".$name."  <span>&nbsp;</span>   ".$email. "</b>" ;
                                        $data[]=array("value"=>$email,"ref"=>$referral,"label"=>$string,"info"=>$seller);
                                    }
                                    $response = appendData($data, '100', TRUE);
                                    echo json_encode($response);
                                }
                                else{
                                    $response = appendData($data, '210', TRUE);
                                    echo json_encode($response);
                                }
                            }
                            else{
                                $response = appendData($data, '411', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else{
                            $response = appendData($data, '413', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else{
                        $response = appendData($data, '410', TRUE);
                        echo json_encode($response);
                    }
                }
                else
                {
                    $response = appendData($data, '111', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'tableAdv':
                if(isset($_SESSION['level'])){
                    if ($_SESSION['level'] == 0) {
                        $query = "SELECT `ID_adv`,`ID_broker`,`ID_seller`,`info_adv`,`advTitle`,`advPrice`,`advStatus` FROM `adv`";
                    } else {
                        $brokerID = $_SESSION['ID'];
                        $query = "SELECT `ID_adv`,`ID_broker`,`ID_seller`,`info_adv`,`advTitle`,`advPrice`,`advStatus` FROM `adv` WHERE `ID_broker`='$brokerID'";
                    }
                    if ($stm = $conn->prepare($query)) {
                        if ($stm->execute()) {
                            $stm->store_result();
                            $stm->bind_result($ID_adv,$ID_broker, $ID_seller, $info, $advTitle, $advPrice,$advStatus);
                            if ($stm->num_rows >= 1) {
                                while ($stm->fetch()) {
                                    $details = json_decode($info, true);
                                    $categoryGroup = $details['categoryGroup'];
                                    $categoryType = $details['categoryType'];
                                    $getLabelStatus=statusAdv($advStatus);
                                    $status=$getLabelStatus['statusLabelDatatable'];
                                    $filter=$_POST['filter'];
                                    if($ID_broker !==1) {
                                        $brokerData = getInfo("broker", $ID_broker, $conn);
                                        $brokerInfo = json_decode($brokerData['info'], true);
                                        $brokerName = $brokerInfo['brokerFirstName'] . " - " . $brokerInfo['brokerLastName'];
                                    }
                                    else{
                                        $brokerName="<b style='text-align: center'>IKKREA</b>";
                                    }

                                    foreach ($_SESSION['categories'] as $keySingleCat => $singleCat) {
                                        if ($keySingleCat == $categoryGroup) {
                                            $categoryGroupName = $singleCat['category_group_name'];
                                        }
                                    }
                                    foreach ($_SESSION['categories'][$categoryGroup]['category_type'] as $keySingleCat => $singleCat) {
                                        if ($singleCat['id'] == $categoryType) {
                                            $categoryTypeName = $singleCat['name'];
                                        }
                                    }
                                    $url = "a.php?i=" . $ID_adv;
                                    $result[] = array(
                                        "adv_url" => $url, "category" => ($categoryGroupName . " - " . $categoryTypeName),
                                        "advTitle" => $advTitle, "advPrice" => $advPrice, "broker" => $brokerName, "status" => $status);
                                }
                                $response = appendData($result, '100', FALSE);
                                echo json_encode($response);
                            } else {
                                $response = appendData($data, '210', TRUE);
                                echo json_encode($response);
                            }
                        } else {
                            $response = appendData($data, '413', TRUE);
                            echo json_encode($response);
                        }
                    } else {
                        $response = appendData($data, '411', TRUE);
                        echo json_encode($response);
                    }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'uploadAdvImage':
                if($_SESSION['level'] <=1){
                        $c = csrfguard_start();
                        if ($c !== "No CSRFName found" && $c !== "Invalid CSRF token.") {
                            $ref = intval($_POST['ref_adv']);
                            if ($ref == $_SESSION['temp_ref_adv_info']) {
                                $validextensions = array("jpg", "png", "jpeg");
                                $Files = reArrayFiles($_FILES['images']);
                                $file_count = count($Files);
                                    if ($file_count <= 6) {
                                        $path = getPathUploadImageAdv($ref);
                                        foreach ($Files as $singleFile) {
                                            if($singleFile["size"]===0){
                                                $response = appendData($Files, '807', TRUE);
                                                echo json_encode($response);
                                            }
                                            else {
                                                $temporary = explode(".", $singleFile["name"]);
                                                $file_extension = end($temporary);
                                                $file_extension = strtolower($file_extension);
                                                $type = $file_extension;
                                                if ((($singleFile["type"] == "image/png") || ($singleFile["type"] == "image/jpg") || ($singleFile["type"] == "image/jpeg"))
                                                    && ($singleFile["size"] < 5482880)//Approx. 5mb files can be uploaded.
                                                    && in_array($file_extension, $validextensions)) {
                                                    if ($singleFile["error"] > 0) {
                                                        $response = appendData($Files, '805', TRUE);
                                                        echo json_encode($response);
                                                    } else {
                                                        $createpath = "../upload_adv/" . $path;
                                                        if (!is_dir($createpath)) {
                                                            mkdir($createpath, 0754);
                                                        }
                                                        $sourcePath = $singleFile['tmp_name'];
                                                        $newFileName = nameFile($singleFile['tmp_name']);
                                                        $targetPath = "../upload_adv/" . $path . "/" . $newFileName . "." . $file_extension;
                                                        if (move_uploaded_file($sourcePath, $targetPath)) {
                                                            $response = appendData(array("Files" => $Files, "count" => $file_count), '100', FALSE);
                                                            echo json_encode($response);
                                                        } else {
                                                            $response = appendData($data, '801', TRUE);
                                                            echo json_encode($response);
                                                        }
                                                    }
                                                } else {
                                                    $response = appendData($data, '802', TRUE);
                                                    echo json_encode($response);
                                                }
                                            }
                                        }
                                    } else {
                                        $response = appendData($data, '806', TRUE);
                                        echo $json = json_encode($response);
                                    }

                            } else {
                                $response = appendData(array($_SESSION['temp_ref_adv'], $ref), '204', TRUE);
                                echo json_encode($response);
                            }
                        } else {
                            if ($c == "No CSRFName found") {
                                $response = appendData($data, '101', TRUE);
                                echo $json = json_encode($response);
                            } elseif ($c !== "Invalid CSRF token") {
                                $response = appendData($data, '102', TRUE);
                                echo $json = json_encode($response);
                            }
                        }
                }
                else{
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'deleteImgAdv':
                if($_SESSION['level'] <=1){
                    if (!empty($_POST['filename']))
                    {
                        $filename=$_POST['filename'];
                        $refPic=getPathUploadImageAdv($_SESSION['temp_ref_adv_info']);
                        $dir = "../upload_adv/" . $refPic."/".$filename;
                        if(unlink($dir))
                        {
                            $response = appendData($data, '100', FALSE);
                            echo json_encode($response);
                        }
                        else {
                            $response = appendData($data, '807', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else
                    {
                        $response = appendData($data, '410', TRUE);
                        echo json_encode($response);
                    }

                }
                else
                {
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'addPayment':
                if($_SESSION['level'] ==1){
                    if(!empty($_POST['details'])) {
                        $details=$_POST['details'];
                        $code=$_POST['code'];
                        switch ($code){
                            case '1':
                                $product=1;
                                break;
                            case '2':
                                $product=2;
                                break;
                            case '3':
                                $product=3;
                                break;
                            case '4':
                                $product=0;
                                break;
                            case '5':
                                $product=5;
                                break;
                            default:
                                $product=0;
                                break;
                        }
                        $status=$details['status'];
                        $brokerID=$_SESSION['ID'];

                        if($status=="COMPLETED") {
                            $now = date('Y-m-d H:i:s', time());
                            $thxID=sanitizeName($details['id']);
                            $payerDetails=$details['payer'];
                            $amount=$details['purchase_units'][0]['amount']['value'];
                            if(($amount==50 && $product==1) || ($amount==120 && $product==2) || ($amount==250 && $product==3 || ($amount==400 && $product==5))) {
                                $currency = $details['purchase_units'][0]['amount']['currency_code'];
                                $payerDet = json_encode($payerDetails, true);
                                $query = "INSERT INTO `payments`(`ID_broker`,`ID_product`,`payer_details`,`amount`,`currency`,`status`,`thxID`,`date_payment`) VALUES (?,?,?,?,?,?,?,?)";
                                if ($stm = $conn->prepare($query)) {
                                    $stm->bind_param("iissssss", $brokerID, $product, $payerDet, $amount, $currency, $status, $thxID, $now);
                                    if ($stm->execute()) {
                                        $update = updateBrokerAdvCounter($brokerID, $product, $now, $conn);
                                        if ($update['error'] == false) {
                                            $url = "thank-you.php?thx=".$thxID;
                                            $_SESSION['tmp_thxID']=$thxID;
                                            $response = appendData($url, '100', FALSE);
                                            echo $json = json_encode($response);
                                        } else {
                                            $response = appendData($update['result'], $update['code'], TRUE);
                                            echo $json = json_encode($response);
                                        }
                                    } else {
                                        $response = appendData($conn->error, '413', TRUE);
                                        echo $json = json_encode($response);
                                    }
                                } else {
                                    $response = appendData($conn->error, '411', TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                            else {
                                $response = appendData($data, '208', TRUE);
                                echo json_encode($response);
                            }
                        }
                        else {
                            $response = appendData($data, '210', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else {
                        $response = appendData($data, '410',TRUE);
                        echo $json = json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'tablePaymentsUser':
                if($_SESSION['level']==1){
                    $id=$_SESSION['ID'];
                    $query="SELECT `ID_payment`,`ID_product`,`status`,`amount`,`currency`,`thxID`,`date_payment` from `payments` WHERE `ID_broker`=?";
                    if ($stm = $conn->prepare($query)) {
                        $stm->bind_param("i",$id);
                        if ($stm->execute()) {
                            $stm->store_result();
                            $stm->bind_result($ID_payment,$ID_product,$status,$amount,$currency,$thxID,$datePayment);
                            if ($stm->num_rows >= 1) {
                                switch ($ID_product){
                                    case '1':
                                        $adv=1;
                                        break;
                                    case'2':
                                        $adv=3;
                                        break;
                                    case '3':
                                        $adv=6;
                                        break;
                                    case'4':
                                        //$adv="SUB";
                                        $adv=0;
                                        break;
                                    case '5':
                                        $adv=10;
                                        break;
                                }
                                while ($stm->fetch()) {
                                    $result[]=array("ID"=>$thxID,"adv"=>$ID_product,"status"=>$status,"amount"=>$amount." ".$currency,"date"=>$datePayment);
                                }
                                $response = appendData($result, '100', FALSE);
                                echo json_encode($response);
                            } else {
                                $response = appendData($data, '210', TRUE);
                                echo json_encode($response);
                            }
                        } else {
                            $response = appendData($data, '413', TRUE);
                            echo json_encode($response);
                        }
                    } else {
                        $response = appendData($data, '411', TRUE);
                        echo json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '112', TRUE);
                    echo json_encode($response);
                }
                break;
            case 'changePwd':
                if(isset($_SESSION['t_login'])){
                    $token = $_SESSION['t_login'];
                    $validToken=isValidToken($token);
                    if ($validToken === true) {
                        $issetToken = issetToken($conn, $token);
                        if ($issetToken['error'] === FALSE) {
                            $c = csrfguard_start();
                            if ($c !== "No CSRFName found" && $c !== "Invalid CSRF token.") {
                                if (!empty($_POST['pwd']) && !empty($_POST['pwdC'])) {
                                    $pwd = $_POST['pwd'];
                                    $pwdConfirm = $_POST['pwdC'];
                                    $email = $_SESSION['username'];
                                    if ($pwd !== $pwdConfirm) {
                                        $response = appendData($data, '417', TRUE);
                                        echo $json = json_encode($response);
                                    } else {
                                        if (!preg_match('/^(?=.*\d)(?=.*[A-Za-z])[0-9A-Za-z_!.&@#$%]{8,20}$/', $pwd)) {
                                            $response = appendData($data, '416', TRUE);
                                            echo $json = json_encode($response);
                                        } else {
                                            $username = $issetToken['info']['username'];
                                            if ($email != $username) {
                                                $response = appendData(array($username,$email), '112', TRUE);
                                                echo json_encode($response);
                                            } else {
                                                $passCrypted = encryptPassword($pwd, $username);
                                                $t_login = $_SESSION['t_login'];
                                                $now = date('Y-m-d H:i:s', time());
                                                $query = "UPDATE `broker` SET `pwd`=? ,`date_pwd_change`=? WHERE `t_login`=? AND `email`=?";
                                                if ($stm = $conn->prepare($query)) {
                                                    $stm->bind_param("ssss", $passCrypted,$now, $t_login,$username);
                                                    if ($stm->execute()) {
                                                        $_SESSION['date_pwd_edit']=$now;
                                                        $response = appendData($data, '100', FALSE);
                                                        echo json_encode($response);
                                                    } else {
                                                        $response = appendData($data, '413', TRUE);
                                                        echo json_encode($response);
                                                    }
                                                } else {
                                                    $response = appendData($data, '411', TRUE);
                                                    echo json_encode($response);
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    $response = appendData($data, '410', TRUE);
                                    echo $json = json_encode($response);
                                }
                            } else {
                                if ($c == "No CSRFName found") {
                                    $response = appendData($data, '101', TRUE);
                                    echo $json = json_encode($response);
                                } elseif ($c !== "Invalid CSRF token") {
                                    $response = appendData($data, '102', TRUE);
                                    echo $json = json_encode($response);
                                }
                            }
                        }
                        else {
                            sleep(1);
                            $response = appendData($data, '206', TRUE);
                            echo json_encode($response);
                        }
                    }
                    else {
                        sleep(1);
                        $response = appendData($token, '207', TRUE);
                        echo json_encode($response);
                    }
                }
                else {
                    $response = appendData($data, '111', TRUE);
                    echo json_encode($response);
                }
                break;
            default:
                sleep(1);
                $response = appendData("Wrong Command", '408',TRUE);
                echo json_encode($response);
                break;
        }
    }
    else {
        $response = appendData($data, '409', TRUE);
        echo json_encode($response);
    }
}


function appendData($data,$resultCode='100',$error)
{
    $resultCodeToText = array
    (
        '100' => 'OK',
        '101' => 'No CSRFName found',
        '102' => 'Invalid CSRF token.',
        '103' => 'Too many Retry account blocked for 5 minutes',
        '104' => 'Email/Password wrong ',
        '105' => 'Qr image Error',
        '106' => 'Qr image Ok',
        '107' => 'Insert Code',
        '108' => 'Error Server Connection aborted',
        '109' => 'Cannot Found Database',
        '110' => 'No Results',
        '111' => 'Not logged',
        '112' => 'Unauthorised',
        '113' => 'Already Logged',
        '114' => 'Validate your Email address',
        '201' => 'Authentication Error',
        '202' => 'Bad Authentication value',
        '203' => 'Bad Authentication parameter',
        '204' => 'Wrong parameter',
        '205' => 'Email Already Exists',
        '206' => 'Token Expired',
        '207' => 'Wrong Token',
        '208' => 'Something wrong',
        '210' => 'No Results.',
        '211' => 'Buy others Adv Publications Token',
        '212' => 'Subscription Expired',
        '213' => 'Error Counter Subscriptions',
        '214' => 'Adv already Published , set draft before',
        '401' => 'Bad request',
        '402' => 'Incorrect Parameter Value',
        '403' => 'User Not Allowed',
        '408' => 'Wrong Command',
        '409' => 'Missing Command',
        '410' => 'Required parameter missing',
        '411' => 'Query Error.',
        '412' => 'DB error. Try again later.',
        '413' => 'Execute Query Error',
        '414' => 'Captcha_Error',
        '415' => 'Captcha_Wrong',
        '416' => 'Missed Password Parameters',
        '417' => 'Different Password',
        '501' => 'Fill the form correctly',
        '502' => 'Email not exists',
        '800' => 'Invalid Type Docs',
        '801' => 'Error Uploading File',
        '802' => 'Invalid file Size or Type',
        '803' => 'Image Uploaded Successfully!',
        '804' => 'File already exists',
        '805' => 'File Error',
        '806' => 'Max 6 upload',
        '807' => 'Select file first'
    );
    $response['resultCode'] = $resultCode;
    $response['errorText'] = $resultCodeToText[$resultCode];
    $response['error'] = $error;
    $response['result'] = $data;
    return $response;
}

