$(document).ready(function() {
    Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
    Chart.defaults.global.defaultFontColor = '#858796';

    $.ajax({
        type: "POST",
        url: "handlers/api_root.php",
        data: {
            command: "getDashboard",
        },
        success: function (data) {
            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === false && result != null) {
                    $('.totAdv').html(result.advReport[0].totalAdv);
                    $('.totClient').html(result.clientReport[0].totalClient);
                    $('.totSeller').html(result.sellerReport[0].totalSeller);
                    $('.totBroker').html(result.brokerReport[0].totalBroker);
                    $('.totPub').html(result.advReport[0].pub);
                    $('.totAdvDraft').html(result.advReport[0].draft);
                    $('.totAdvCompleted').html(result.advReport[0].completed);
                    $('.totAdvRejected').html(result.advReport[0].rejected);
                    $('.totAdvPending').html(result.advReport[0].pending);
                    $('.totSubs').html(result.totSubs);
                    $('.earningT').html(result.totP);
                    $('.pubByed').html(result.totAdvPayed);
                    createChartAdv(result.advReport[0]);
                }
            }
        }
    });

    var start = moment().subtract(29, 'days');
    var end = moment();

    var ita_date = {
        "direction": "ltr",
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Applica",
        "cancelLabel": "Annulla",
        "fromLabel": "Da",
        "toLabel": "A",
        "customRangeLabel": "Personalizzata",
        "daysOfWeek": [
            "Do",
            "Lu",
            "Ma",
            "Me",
            "Gi",
            "Ve",
            "Sa"
        ],
        "monthNames": [
            "Gennaio",
            "Febbraio",
            "Marzo",
            "April",
            "Maggio",
            "Giugno",
            "Luglio",
            "Agosto",
            "Settembre",
            "Ottobre",
            "Novembre",
            "Dicembre"
        ],
        "firstDay": 1
    };
    var ita_ranges = {
        'Oggi': [moment(), moment()],
        'Ieri': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        '7 Giorni': [moment().subtract(6, 'days'), moment()],
        '30 Giorni': [moment().subtract(29, 'days'), moment()],
        'Questo Mese': [moment().startOf('month'), moment().endOf('month')],
        'Mese Scorso': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    };
    $('#reportrange').daterangepicker({
        locale : ita_date,
        startDate: start,
        endDate: end,
        ranges: ita_ranges
    }, chartBalance);
    chartBalance(start, end);






});
function chartBalance(start, end) {
    $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    $('.chart-area').empty();
    var first=start.format('YYYY-MM-DD');
    var last=end.format('YYYY-MM-DD');
    $.ajax({
        type: "POST",
        url: "handlers/api_root.php",
        data: {
            command: "getBalances",
            last:last,
            first:first
        },
        success: function (data) {
            if (IsJsonString(data) === true) {
                var data_obj = $.parseJSON(data);
                var code = data_obj['resultCode'];
                var error = data_obj['error'];
                var errorText = data_obj['errorText'];
                var result = data_obj['result'];
                if (error === true ) {
                    result.values=0;
                    $('.chart-area').append("<h6 class='text-center'><span data-translate='_noResultFound'>No Results</span></h6>")

                }
                else{
                    $('.chart-area').append("<canvas id=\"myAreaChart\" style=\"display: block; width: 1039px; height: 320px;\" width=\"1039\" height=\"320\" class=\"chartjs-render-monitor\"></canvas>\n")
                    var ctx = document.getElementById("myAreaChart");
                    var myBarChart = new Chart(ctx, {
                        type: 'bar',
                        data: {
                            labels: result.labels,
                            datasets: [{
                                label: "Earnings",
                                backgroundColor: "#4e73df",
                                hoverBackgroundColor: "#2e59d9",
                                borderColor: "#4e73df",
                                data: result.values,
                            }],
                        },
                        options: {
                            maintainAspectRatio: false,
                            layout: {
                                padding: {
                                    left: 10,
                                    right: 25,
                                    top: 25,
                                    bottom: 0
                                }
                            },
                            scales: {
                                xAxes: [{
                                    time: {
                                        unit: 'date'
                                    },
                                    gridLines: {
                                        display: false,
                                        drawBorder: false
                                    },
                                    ticks: {
                                        maxTicksLimit: 31
                                    },
                                    maxBarThickness: 25,
                                }],
                                yAxes: [{
                                    ticks: {
                                        min: 0,
                                        max: result.max,
                                        maxTicksLimit: 10,
                                        padding: 10,
                                        callback: function(value, index, values) {
                                            return '€' + number_format(value);
                                        }
                                    },
                                    gridLines: {
                                        color: "rgb(234, 236, 244)",
                                        zeroLineColor: "rgb(234, 236, 244)",
                                        drawBorder: false,
                                        borderDash: [2],
                                        zeroLineBorderDash: [2]
                                    }
                                }],
                            },
                            legend: {
                                display: false
                            },
                            tooltips: {
                                titleMarginBottom: 10,
                                titleFontColor: '#6e707e',
                                titleFontSize: 14,
                                backgroundColor: "rgb(255,255,255)",
                                bodyFontColor: "#858796",
                                borderColor: '#dddfeb',
                                borderWidth: 1,
                                xPadding: 15,
                                yPadding: 15,
                                displayColors: false,
                                caretPadding: 10,
                                callbacks: {
                                    label: function(tooltipItem, chart) {
                                        var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                        return datasetLabel + ': €' + number_format(tooltipItem.yLabel);
                                    }
                                }
                            },
                        }
                    });
                }
                // Bar Chart Example

            }
        }
    });
    Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
    Chart.defaults.global.defaultFontColor = '#858796';

    function number_format(number, decimals, dec_point, thousands_sep) {
        // *     example: number_format(1234.56, 2, ',', ' ');
        // *     return: '1 234,56'
        number = (number + '').replace(',', '').replace(' ', '');
        var n = !isFinite(+number) ? 0 : +number,
            prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
            sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
            dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
            s = '',
            toFixedFix = function(n, prec) {
                var k = Math.pow(10, prec);
                return '' + Math.round(n * k) / k;
            };
        // Fix for IE parseFloat(0.55).toFixed(0) = 0;
        s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
        if (s[0].length > 3) {
            s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
        }
        if ((s[1] || '').length < prec) {
            s[1] = s[1] || '';
            s[1] += new Array(prec - s[1].length + 1).join('0');
        }
        return s.join(dec);
    }

    // Area Chart Example


}
function createChartAdv(advReport) {

    var advReportDiv = document.getElementById("advReport");
    var myPieChart = new Chart(advReportDiv, {
        type: 'doughnut',
        data: {
            labels: ["Pubblicata", "Bozza", "Completata","Rifiutata","In approvazione"],
            datasets: [{
                data: [advReport.pub,advReport.draft,advReport.completed,advReport.rejected,advReport.pending],
                backgroundColor: ['#36b9cc','#858796','#1cc88a','#e74a3b','#f6c23e'],
                hoverBackgroundColor: ['#2c9faf','#858796', '#17a673','#e74a3b','#f6c23e'],
                hoverBorderColor: "rgba(234, 236, 244, 1)",
            }],
        },
        options: {
            maintainAspectRatio: false,
            tooltips: {
                backgroundColor: "rgb(255,255,255)",
                bodyFontColor: "#858796",
                borderColor: '#dddfeb',
                borderWidth: 1,
                xPadding: 15,
                yPadding: 15,
                displayColors: false,
                caretPadding: 10,
            },
            legend: {
                display: false
            },
            cutoutPercentage: 80,
        },
    });
}