$( document ).ready(function() {


    $('.search-input-broker').autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "handlers/api.php",
                type: "POST",
                cache: false,
                async: false,
                data: {
                    searchBroker: request.term, command: "autoCompleteSearchBroker"
                },
                success: function (data) {
                    if (!data.length) {
                        var res = [
                            {
                                label: 'No matches found',
                                value: response.term
                            }
                        ];
                        response(res);
                    } else {
                        if (IsJsonString(data) === true) {
                            var data_obj = $.parseJSON(data);
                            var code = data_obj['resultCode'];
                            var error = data_obj['error'];
                            var errorText = data_obj['errorText'];
                            var result = data_obj['result'];

                            if (code === "111") {
                                location.reload();
                            }
                            if (code === "100") {
                                response(result);
                            } else {

                                var r = [{
                                    label: errorText,
                                    value: response.term
                                }];
                                response(r);
                                traduction();

                            }
                            $('.ui-menu-item').addClass("form-control");
                        }
                    }
                }
            });
        },
        minLength: 3,
        response: function (event, ui) {

        },
        select: function (event, ui) {
            if (ui.item.value !== "No Results.") {
                brokerTable(ui);

                console.log(ui);
                traduction();
            }
        }
    }).autocomplete("instance")._renderItem = function (ul, item) {
        traduction();
        if (item.value === "No Results.") {
            $("#empty-message").html("");
            $('#brokerTable').hide();
            s = $("#empty-message").append("<div style='margin-top: 10px'><span data-translate='_noResults'>No results.</span></div>");
            return s;
        } else {
            string = "<div>" + item.label + "</div>";
            return $("<li>").append(string).appendTo(ul);
        }
    };

    $('.setRejected').click( function() {
        $('#confirmSetRejectedAdv').modal('show');
    });
    $('.setApproved').click( function() {
        $('#confirmSetApprovedAdv').modal('show');
    });
    $('.setCompleted').click( function() {
        $('#confirmSetCompletedAdv').modal('show');
    });
    $('.confirmSetRejectedAdvBtn').click( function() {
        var i = getUrlVars()["i"];
        var $this = $('.confirmSetRejectedAdvBtn');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "setRejected",
                i:i,
            },
            success: function (data) {
                $this.html("<span data-translate=\"_setRejected\">Set Rejected</span>");
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    if (error === false ) {
                        location.reload();
                    }
                    else{
                        $('#resultRejected').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
            }
        });
    });
    $('.confirmSetApprovedAdvBtn').click( function() {
        var i = getUrlVars()["i"];
        var $this = $('.confirmSetApprovedAdvBtn');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "setApproved",
                i:i,
            },
            success: function (data) {
                $this.html("<span data-translate=\"_setApproved\">Set Approved</span>");
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    if (error === false) {
                        location.reload();
                    }
                    else{
                        $('#resultApproved').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
            }
        });
    });
    $('.confirmSetCompletedAdvBtn').click( function() {
        var i = getUrlVars()["i"];
        var $this = $('.confirmSetCompletedAdvBtn');
        var loadingText = '<i class="fa fa-circle-o-notch fa-spin"></i> Loading...';
        if ($(this).html() !== loadingText) {
            $this.data('original-text', $(this).html());
            $this.html(loadingText);
        }
        $.ajax({
            type: "POST",
            url: "handlers/api.php",
            data: {
                command: "setCompleted",
                i:i,
            },
            success: function (data) {
                $this.html("<span data-translate=\"_setCompleted\">Set Completed</span>");
                if (IsJsonString(data) === true) {
                    var data_obj = $.parseJSON(data);
                    var code = data_obj['resultCode'];
                    var error = data_obj['error'];
                    var errorText = data_obj['errorText'];
                    if (error === false) {
                       location.reload();
                    }
                    else{
                        $('#resultCompleted').html('<span style="color: red" data-translate="_error'+code+'">'+errorText+'</span>');
                        traduction();
                    }
                }
            }
        });
    });


});


function brokerTable(ui) {
    $('#brokerTable').show();
    if(ui) {
        $( ".nav-link-broker#2 ").trigger( "click" );
        $('#brokerName').val(ui.item.info.name).attr("disabled",true);
        $('#autocompleteE').val(ui.item.info.email);
        $('#brokerEmail').val(ui.item.info.email).attr("disabled",true);
    }
}



